package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAccountSettingsResponse(
    accountSettings: zio.aws.proton.model.AccountSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse = {
    import UpdateAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse
      .builder()
      .accountSettings(accountSettings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly =
    zio.aws.proton.model.UpdateAccountSettingsResponse.wrap(buildAwsValue())
}
object UpdateAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateAccountSettingsResponse =
      zio.aws.proton.model
        .UpdateAccountSettingsResponse(accountSettings.asEditable)
    def accountSettings: zio.aws.proton.model.AccountSettings.ReadOnly
    def getAccountSettings
        : ZIO[Any, Nothing, zio.aws.proton.model.AccountSettings.ReadOnly] =
      ZIO.succeed(accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse
  ) extends zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly {
    override val accountSettings
        : zio.aws.proton.model.AccountSettings.ReadOnly =
      zio.aws.proton.model.AccountSettings.wrap(impl.accountSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateAccountSettingsResponse
  ): zio.aws.proton.model.UpdateAccountSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
