package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, DisplayName, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateEnvironmentTemplateRequest(
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest = {
    import UpdateEnvironmentTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateEnvironmentTemplateRequest.ReadOnly =
    zio.aws.proton.model.UpdateEnvironmentTemplateRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateEnvironmentTemplateRequest =
      zio.aws.proton.model.UpdateEnvironmentTemplateRequest(
        description.map(value => value),
        displayName.map(value => value),
        name
      )
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def name: ResourceName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
  ) extends zio.aws.proton.model.UpdateEnvironmentTemplateRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateEnvironmentTemplateRequest
  ): zio.aws.proton.model.UpdateEnvironmentTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
