package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  SpecContents,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServicePipelineRequest(
    deploymentType: zio.aws.proton.model.DeploymentUpdateType,
    serviceName: ResourceName,
    spec: SpecContents,
    templateMajorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    templateMinorVersion: Optional[TemplateVersionPart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest = {
    import UpdateServicePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest
      .builder()
      .deploymentType(deploymentType.unwrap)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .optionallyWith(
        templateMajorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMajorVersion)
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServicePipelineRequest.ReadOnly =
    zio.aws.proton.model.UpdateServicePipelineRequest.wrap(buildAwsValue())
}
object UpdateServicePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServicePipelineRequest =
      zio.aws.proton.model.UpdateServicePipelineRequest(
        deploymentType,
        serviceName,
        spec,
        templateMajorVersion.map(value => value),
        templateMinorVersion.map(value => value)
      )
    def deploymentType: zio.aws.proton.model.DeploymentUpdateType
    def serviceName: ResourceName
    def spec: SpecContents
    def templateMajorVersion: Optional[TemplateVersionPart]
    def templateMinorVersion: Optional[TemplateVersionPart]
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentUpdateType] =
      ZIO.succeed(deploymentType)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getTemplateMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMajorVersion", templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest
  ) extends zio.aws.proton.model.UpdateServicePipelineRequest.ReadOnly {
    override val deploymentType: zio.aws.proton.model.DeploymentUpdateType =
      zio.aws.proton.model.DeploymentUpdateType.wrap(impl.deploymentType())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val templateMajorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMajorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val templateMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServicePipelineRequest
  ): zio.aws.proton.model.UpdateServicePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
