package zio.aws.proton.model
import zio.aws.proton.model.primitives.{SpecContents, ResourceName, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceRequest(
    description: Optional[Description] = Optional.Absent,
    name: ResourceName,
    spec: Optional[SpecContents] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceRequest.ReadOnly =
    zio.aws.proton.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceRequest =
      zio.aws.proton.model.UpdateServiceRequest(
        description.map(value => value),
        name,
        spec.map(value => value)
      )
    def description: Optional[Description]
    def name: ResourceName
    def spec: Optional[SpecContents]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceRequest
  ) extends zio.aws.proton.model.UpdateServiceRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val spec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceRequest
  ): zio.aws.proton.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
