package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceResponse(service: zio.aws.proton.model.Service) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceResponse = {
    import UpdateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceResponse.ReadOnly =
    zio.aws.proton.model.UpdateServiceResponse.wrap(buildAwsValue())
}
object UpdateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceResponse =
      zio.aws.proton.model.UpdateServiceResponse(service.asEditable)
    def service: zio.aws.proton.model.Service.ReadOnly
    def getService: ZIO[Any, Nothing, zio.aws.proton.model.Service.ReadOnly] =
      ZIO.succeed(service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceResponse
  ) extends zio.aws.proton.model.UpdateServiceResponse.ReadOnly {
    override val service: zio.aws.proton.model.Service.ReadOnly =
      zio.aws.proton.model.Service.wrap(impl.service())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceResponse
  ): zio.aws.proton.model.UpdateServiceResponse.ReadOnly = new Wrapper(impl)
}
