package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceSyncBlockerResponse(
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: ResourceName,
    serviceSyncBlocker: zio.aws.proton.model.SyncBlocker
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerResponse = {
    import UpdateServiceSyncBlockerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerResponse
      .builder()
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .serviceSyncBlocker(serviceSyncBlocker.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateServiceSyncBlockerResponse.ReadOnly =
    zio.aws.proton.model.UpdateServiceSyncBlockerResponse.wrap(buildAwsValue())
}
object UpdateServiceSyncBlockerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceSyncBlockerResponse =
      zio.aws.proton.model.UpdateServiceSyncBlockerResponse(
        serviceInstanceName.map(value => value),
        serviceName,
        serviceSyncBlocker.asEditable
      )
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: ResourceName
    def serviceSyncBlocker: zio.aws.proton.model.SyncBlocker.ReadOnly
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
    def getServiceSyncBlocker
        : ZIO[Any, Nothing, zio.aws.proton.model.SyncBlocker.ReadOnly] =
      ZIO.succeed(serviceSyncBlocker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerResponse
  ) extends zio.aws.proton.model.UpdateServiceSyncBlockerResponse.ReadOnly {
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
    override val serviceSyncBlocker: zio.aws.proton.model.SyncBlocker.ReadOnly =
      zio.aws.proton.model.SyncBlocker.wrap(impl.serviceSyncBlocker())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceSyncBlockerResponse
  ): zio.aws.proton.model.UpdateServiceSyncBlockerResponse.ReadOnly =
    new Wrapper(impl)
}
