package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  RepositoryName,
  OpsFilePath,
  GitBranchName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceSyncConfigRequest(
    branch: GitBranchName,
    filePath: OpsFilePath,
    repositoryName: RepositoryName,
    repositoryProvider: zio.aws.proton.model.RepositoryProvider,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest = {
    import UpdateServiceSyncConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .filePath(OpsFilePath.unwrap(filePath): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .repositoryProvider(repositoryProvider.unwrap)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceSyncConfigRequest.ReadOnly =
    zio.aws.proton.model.UpdateServiceSyncConfigRequest.wrap(buildAwsValue())
}
object UpdateServiceSyncConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceSyncConfigRequest =
      zio.aws.proton.model.UpdateServiceSyncConfigRequest(
        branch,
        filePath,
        repositoryName,
        repositoryProvider,
        serviceName
      )
    def branch: GitBranchName
    def filePath: OpsFilePath
    def repositoryName: RepositoryName
    def repositoryProvider: zio.aws.proton.model.RepositoryProvider
    def serviceName: ResourceName
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getFilePath: ZIO[Any, Nothing, OpsFilePath] = ZIO.succeed(filePath)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(repositoryProvider)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest
  ) extends zio.aws.proton.model.UpdateServiceSyncConfigRequest.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val filePath: OpsFilePath =
      zio.aws.proton.model.primitives.OpsFilePath(impl.filePath())
    override val repositoryName: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryProvider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.repositoryProvider())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceSyncConfigRequest
  ): zio.aws.proton.model.UpdateServiceSyncConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
