package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, DisplayName, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceTemplateRequest(
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest = {
    import UpdateServiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceTemplateRequest.ReadOnly =
    zio.aws.proton.model.UpdateServiceTemplateRequest.wrap(buildAwsValue())
}
object UpdateServiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceTemplateRequest =
      zio.aws.proton.model.UpdateServiceTemplateRequest(
        description.map(value => value),
        displayName.map(value => value),
        name
      )
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def name: ResourceName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest
  ) extends zio.aws.proton.model.UpdateServiceTemplateRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateRequest
  ): zio.aws.proton.model.UpdateServiceTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
