package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceTemplateResponse(
    serviceTemplate: zio.aws.proton.model.ServiceTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse = {
    import UpdateServiceTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse
      .builder()
      .serviceTemplate(serviceTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly =
    zio.aws.proton.model.UpdateServiceTemplateResponse.wrap(buildAwsValue())
}
object UpdateServiceTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceTemplateResponse =
      zio.aws.proton.model
        .UpdateServiceTemplateResponse(serviceTemplate.asEditable)
    def serviceTemplate: zio.aws.proton.model.ServiceTemplate.ReadOnly
    def getServiceTemplate
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceTemplate.ReadOnly] =
      ZIO.succeed(serviceTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse
  ) extends zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly {
    override val serviceTemplate
        : zio.aws.proton.model.ServiceTemplate.ReadOnly =
      zio.aws.proton.model.ServiceTemplate.wrap(impl.serviceTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateResponse
  ): zio.aws.proton.model.UpdateServiceTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
