package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTemplateSyncConfigResponse(
    templateSyncConfig: Optional[zio.aws.proton.model.TemplateSyncConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse = {
    import UpdateTemplateSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse
      .builder()
      .optionallyWith(templateSyncConfig.map(value => value.buildAwsValue()))(
        _.templateSyncConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.UpdateTemplateSyncConfigResponse.wrap(buildAwsValue())
}
object UpdateTemplateSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateTemplateSyncConfigResponse =
      zio.aws.proton.model.UpdateTemplateSyncConfigResponse(
        templateSyncConfig.map(value => value.asEditable)
      )
    def templateSyncConfig
        : Optional[zio.aws.proton.model.TemplateSyncConfig.ReadOnly]
    def getTemplateSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.TemplateSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("templateSyncConfig", templateSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse
  ) extends zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly {
    override val templateSyncConfig
        : Optional[zio.aws.proton.model.TemplateSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateSyncConfig())
        .map(value => zio.aws.proton.model.TemplateSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateTemplateSyncConfigResponse
  ): zio.aws.proton.model.UpdateTemplateSyncConfigResponse.ReadOnly =
    new Wrapper(impl)
}
