package zio.aws.qldb
import zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly
import software.amazon.awssdk.services.qldb.QldbAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.qldb.model.{
  UpdateLedgerPermissionsModeRequest,
  DescribeJournalKinesisStreamRequest,
  DeleteLedgerRequest,
  ListJournalKinesisStreamsForLedgerRequest,
  ListTagsForResourceRequest,
  ExportJournalToS3Request,
  GetRevisionRequest,
  ListJournalS3ExportsRequest,
  CancelJournalKinesisStreamRequest,
  ListJournalS3ExportsForLedgerRequest,
  ListLedgersRequest,
  StreamJournalToKinesisRequest,
  UpdateLedgerRequest,
  GetBlockRequest,
  UntagResourceRequest,
  GetDigestRequest,
  DescribeLedgerRequest,
  DescribeJournalS3ExportRequest,
  TagResourceRequest,
  CreateLedgerRequest
}
import zio.stream.ZStream
object QldbMock extends Mock[Qldb] {
  object DescribeLedger
      extends Effect[
        DescribeLedgerRequest,
        AwsError,
        zio.aws.qldb.model.DescribeLedgerResponse.ReadOnly
      ]
  object UpdateLedgerPermissionsMode
      extends Effect[
        UpdateLedgerPermissionsModeRequest,
        AwsError,
        zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly
      ]
  object GetBlock
      extends Effect[
        GetBlockRequest,
        AwsError,
        zio.aws.qldb.model.GetBlockResponse.ReadOnly
      ]
  object StreamJournalToKinesis
      extends Effect[
        StreamJournalToKinesisRequest,
        AwsError,
        zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly
      ]
  object ListJournalS3Exports
      extends Stream[
        ListJournalS3ExportsRequest,
        AwsError,
        zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
      ]
  object ListJournalS3ExportsPaginated
      extends Effect[
        ListJournalS3ExportsRequest,
        AwsError,
        zio.aws.qldb.model.ListJournalS3ExportsResponse.ReadOnly
      ]
  object CancelJournalKinesisStream
      extends Effect[
        CancelJournalKinesisStreamRequest,
        AwsError,
        zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly
      ]
  object ListJournalS3ExportsForLedger
      extends Stream[
        ListJournalS3ExportsForLedgerRequest,
        AwsError,
        zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
      ]
  object ListJournalS3ExportsForLedgerPaginated
      extends Effect[
        ListJournalS3ExportsForLedgerRequest,
        AwsError,
        zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly
      ]
  object ListJournalKinesisStreamsForLedger
      extends Stream[
        ListJournalKinesisStreamsForLedgerRequest,
        AwsError,
        zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
      ]
  object ListJournalKinesisStreamsForLedgerPaginated
      extends Effect[
        ListJournalKinesisStreamsForLedgerRequest,
        AwsError,
        ReadOnly
      ]
  object DeleteLedger extends Effect[DeleteLedgerRequest, AwsError, Unit]
  object CreateLedger
      extends Effect[
        CreateLedgerRequest,
        AwsError,
        zio.aws.qldb.model.CreateLedgerResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.qldb.model.UntagResourceResponse.ReadOnly
      ]
  object GetRevision
      extends Effect[
        GetRevisionRequest,
        AwsError,
        zio.aws.qldb.model.GetRevisionResponse.ReadOnly
      ]
  object GetDigest
      extends Effect[
        GetDigestRequest,
        AwsError,
        zio.aws.qldb.model.GetDigestResponse.ReadOnly
      ]
  object UpdateLedger
      extends Effect[
        UpdateLedgerRequest,
        AwsError,
        zio.aws.qldb.model.UpdateLedgerResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.qldb.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListLedgers
      extends Stream[
        ListLedgersRequest,
        AwsError,
        zio.aws.qldb.model.LedgerSummary.ReadOnly
      ]
  object ListLedgersPaginated
      extends Effect[
        ListLedgersRequest,
        AwsError,
        zio.aws.qldb.model.ListLedgersResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.qldb.model.TagResourceResponse.ReadOnly
      ]
  object DescribeJournalS3Export
      extends Effect[
        DescribeJournalS3ExportRequest,
        AwsError,
        zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly
      ]
  object ExportJournalToS3
      extends Effect[
        ExportJournalToS3Request,
        AwsError,
        zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly
      ]
  object DescribeJournalKinesisStream
      extends Effect[
        DescribeJournalKinesisStreamRequest,
        AwsError,
        zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Qldb] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Qldb] { rts =>
        zio.ZIO.succeed {
          new Qldb {
            val api: QldbAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Qldb = this
            def describeLedger(request: DescribeLedgerRequest): IO[
              AwsError,
              zio.aws.qldb.model.DescribeLedgerResponse.ReadOnly
            ] = proxy(DescribeLedger, request)
            def updateLedgerPermissionsMode(
                request: UpdateLedgerPermissionsModeRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly
            ] = proxy(UpdateLedgerPermissionsMode, request)
            def getBlock(
                request: GetBlockRequest
            ): IO[AwsError, zio.aws.qldb.model.GetBlockResponse.ReadOnly] =
              proxy(GetBlock, request)
            def streamJournalToKinesis(
                request: StreamJournalToKinesisRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly
            ] = proxy(StreamJournalToKinesis, request)
            def listJournalS3Exports(
                request: ListJournalS3ExportsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
            ] = rts.unsafeRun(proxy(ListJournalS3Exports, request))
            def listJournalS3ExportsPaginated(
                request: ListJournalS3ExportsRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.ListJournalS3ExportsResponse.ReadOnly
            ] = proxy(ListJournalS3ExportsPaginated, request)
            def cancelJournalKinesisStream(
                request: CancelJournalKinesisStreamRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly
            ] = proxy(CancelJournalKinesisStream, request)
            def listJournalS3ExportsForLedger(
                request: ListJournalS3ExportsForLedgerRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
            ] = rts.unsafeRun(proxy(ListJournalS3ExportsForLedger, request))
            def listJournalS3ExportsForLedgerPaginated(
                request: ListJournalS3ExportsForLedgerRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly
            ] = proxy(ListJournalS3ExportsForLedgerPaginated, request)
            def listJournalKinesisStreamsForLedger(
                request: ListJournalKinesisStreamsForLedgerRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
            ] =
              rts.unsafeRun(proxy(ListJournalKinesisStreamsForLedger, request))
            def listJournalKinesisStreamsForLedgerPaginated(
                request: ListJournalKinesisStreamsForLedgerRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListJournalKinesisStreamsForLedgerPaginated, request)
            def deleteLedger(request: DeleteLedgerRequest): IO[AwsError, Unit] =
              proxy(DeleteLedger, request)
            def createLedger(
                request: CreateLedgerRequest
            ): IO[AwsError, zio.aws.qldb.model.CreateLedgerResponse.ReadOnly] =
              proxy(CreateLedger, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.qldb.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def getRevision(
                request: GetRevisionRequest
            ): IO[AwsError, zio.aws.qldb.model.GetRevisionResponse.ReadOnly] =
              proxy(GetRevision, request)
            def getDigest(
                request: GetDigestRequest
            ): IO[AwsError, zio.aws.qldb.model.GetDigestResponse.ReadOnly] =
              proxy(GetDigest, request)
            def updateLedger(
                request: UpdateLedgerRequest
            ): IO[AwsError, zio.aws.qldb.model.UpdateLedgerResponse.ReadOnly] =
              proxy(UpdateLedger, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.qldb.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listLedgers(request: ListLedgersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.qldb.model.LedgerSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListLedgers, request))
            def listLedgersPaginated(
                request: ListLedgersRequest
            ): IO[AwsError, zio.aws.qldb.model.ListLedgersResponse.ReadOnly] =
              proxy(ListLedgersPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.qldb.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def describeJournalS3Export(
                request: DescribeJournalS3ExportRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly
            ] = proxy(DescribeJournalS3Export, request)
            def exportJournalToS3(request: ExportJournalToS3Request): IO[
              AwsError,
              zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly
            ] = proxy(ExportJournalToS3, request)
            def describeJournalKinesisStream(
                request: DescribeJournalKinesisStreamRequest
            ): IO[
              AwsError,
              zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly
            ] = proxy(DescribeJournalKinesisStream, request)
          }
        }
      }
    }
  }
}
