package zio.aws.qldb.model
import scala.jdk.CollectionConverters._
sealed trait ExportStatus {
  def unwrap: software.amazon.awssdk.services.qldb.model.ExportStatus
}
object ExportStatus {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.ExportStatus
  ): zio.aws.qldb.model.ExportStatus = value match {
    case software.amazon.awssdk.services.qldb.model.ExportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.ExportStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.qldb.model.ExportStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.qldb.model.ExportStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.ExportStatus =
      software.amazon.awssdk.services.qldb.model.ExportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.qldb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.ExportStatus =
      software.amazon.awssdk.services.qldb.model.ExportStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.qldb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.ExportStatus =
      software.amazon.awssdk.services.qldb.model.ExportStatus.COMPLETED
  }
  case object CANCELLED extends zio.aws.qldb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.ExportStatus =
      software.amazon.awssdk.services.qldb.model.ExportStatus.CANCELLED
  }
}
