package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLedgersResponse(
    ledgers: Optional[Iterable[zio.aws.qldb.model.LedgerSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.ListLedgersResponse = {
    import ListLedgersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.ListLedgersResponse
      .builder()
      .optionallyWith(
        ledgers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ledgers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.ListLedgersResponse.ReadOnly =
    zio.aws.qldb.model.ListLedgersResponse.wrap(buildAwsValue())
}
object ListLedgersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.ListLedgersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.ListLedgersResponse =
      zio.aws.qldb.model.ListLedgersResponse(
        ledgers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ledgers: Optional[List[zio.aws.qldb.model.LedgerSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLedgers
        : ZIO[Any, AwsError, List[zio.aws.qldb.model.LedgerSummary.ReadOnly]] =
      AwsError.unwrapOptionField("ledgers", ledgers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.ListLedgersResponse
  ) extends zio.aws.qldb.model.ListLedgersResponse.ReadOnly {
    override val ledgers
        : Optional[List[zio.aws.qldb.model.LedgerSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ledgers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.qldb.model.LedgerSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.qldb.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.ListLedgersResponse
  ): zio.aws.qldb.model.ListLedgersResponse.ReadOnly = new Wrapper(impl)
}
