package zio.aws.qldb.model
import scala.jdk.CollectionConverters._
sealed trait PermissionsMode {
  def unwrap: software.amazon.awssdk.services.qldb.model.PermissionsMode
}
object PermissionsMode {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.PermissionsMode
  ): zio.aws.qldb.model.PermissionsMode = value match {
    case software.amazon.awssdk.services.qldb.model.PermissionsMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.PermissionsMode.ALLOW_ALL =>
      val r = ALLOW_ALL
      r
    case software.amazon.awssdk.services.qldb.model.PermissionsMode.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.PermissionsMode {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.PermissionsMode =
      software.amazon.awssdk.services.qldb.model.PermissionsMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW_ALL extends zio.aws.qldb.model.PermissionsMode {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.PermissionsMode =
      software.amazon.awssdk.services.qldb.model.PermissionsMode.ALLOW_ALL
  }
  case object STANDARD extends zio.aws.qldb.model.PermissionsMode {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.PermissionsMode =
      software.amazon.awssdk.services.qldb.model.PermissionsMode.STANDARD
  }
}
