package zio.aws.qldb.model
import scala.jdk.CollectionConverters._
sealed trait StreamStatus {
  def unwrap: software.amazon.awssdk.services.qldb.model.StreamStatus
}
object StreamStatus {
  def wrap(
      value: software.amazon.awssdk.services.qldb.model.StreamStatus
  ): zio.aws.qldb.model.StreamStatus = value match {
    case software.amazon.awssdk.services.qldb.model.StreamStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.qldb.model.StreamStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.qldb.model.StreamStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.qldb.model.StreamStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.qldb.model.StreamStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.qldb.model.StreamStatus.IMPAIRED =>
      val r = IMPAIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.qldb.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.StreamStatus =
      software.amazon.awssdk.services.qldb.model.StreamStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.qldb.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.StreamStatus =
      software.amazon.awssdk.services.qldb.model.StreamStatus.ACTIVE
  }
  case object COMPLETED extends zio.aws.qldb.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.StreamStatus =
      software.amazon.awssdk.services.qldb.model.StreamStatus.COMPLETED
  }
  case object CANCELED extends zio.aws.qldb.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.StreamStatus =
      software.amazon.awssdk.services.qldb.model.StreamStatus.CANCELED
  }
  case object FAILED extends zio.aws.qldb.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.StreamStatus =
      software.amazon.awssdk.services.qldb.model.StreamStatus.FAILED
  }
  case object IMPAIRED extends zio.aws.qldb.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.qldb.model.StreamStatus =
      software.amazon.awssdk.services.qldb.model.StreamStatus.IMPAIRED
  }
}
