package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.Digest
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDigestResponse(
    digest: Digest,
    digestTipAddress: zio.aws.qldb.model.ValueHolder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.GetDigestResponse = {
    import GetDigestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.GetDigestResponse
      .builder()
      .digest(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(digest.toArray[Byte])
      )
      .digestTipAddress(digestTipAddress.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.GetDigestResponse.ReadOnly =
    zio.aws.qldb.model.GetDigestResponse.wrap(buildAwsValue())
}
object GetDigestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.GetDigestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.GetDigestResponse =
      zio.aws.qldb.model.GetDigestResponse(digest, digestTipAddress.asEditable)
    def digest: Digest
    def digestTipAddress: zio.aws.qldb.model.ValueHolder.ReadOnly
    def getDigest: ZIO[Any, Nothing, Digest] = ZIO.succeed(digest)
    def getDigestTipAddress
        : ZIO[Any, Nothing, zio.aws.qldb.model.ValueHolder.ReadOnly] =
      ZIO.succeed(digestTipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.GetDigestResponse
  ) extends zio.aws.qldb.model.GetDigestResponse.ReadOnly {
    override val digest: Digest = zio.aws.qldb.model.primitives
      .Digest(zio.Chunk.fromArray(impl.digest().asByteArrayUnsafe()))
    override val digestTipAddress: zio.aws.qldb.model.ValueHolder.ReadOnly =
      zio.aws.qldb.model.ValueHolder.wrap(impl.digestTipAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.GetDigestResponse
  ): zio.aws.qldb.model.GetDigestResponse.ReadOnly = new Wrapper(impl)
}
