package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{S3Prefix, S3Bucket}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3ExportConfiguration(
    bucket: S3Bucket,
    prefix: S3Prefix,
    encryptionConfiguration: zio.aws.qldb.model.S3EncryptionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.S3ExportConfiguration = {
    import S3ExportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.S3ExportConfiguration
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .prefix(S3Prefix.unwrap(prefix): java.lang.String)
      .encryptionConfiguration(encryptionConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.S3ExportConfiguration.ReadOnly =
    zio.aws.qldb.model.S3ExportConfiguration.wrap(buildAwsValue())
}
object S3ExportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.S3ExportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.S3ExportConfiguration =
      zio.aws.qldb.model.S3ExportConfiguration(
        bucket,
        prefix,
        encryptionConfiguration.asEditable
      )
    def bucket: S3Bucket
    def prefix: S3Prefix
    def encryptionConfiguration
        : zio.aws.qldb.model.S3EncryptionConfiguration.ReadOnly
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, Nothing, S3Prefix] = ZIO.succeed(prefix)
    def getEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.qldb.model.S3EncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(encryptionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.S3ExportConfiguration
  ) extends zio.aws.qldb.model.S3ExportConfiguration.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.qldb.model.primitives.S3Bucket(impl.bucket())
    override val prefix: S3Prefix =
      zio.aws.qldb.model.primitives.S3Prefix(impl.prefix())
    override val encryptionConfiguration
        : zio.aws.qldb.model.S3EncryptionConfiguration.ReadOnly =
      zio.aws.qldb.model.S3EncryptionConfiguration
        .wrap(impl.encryptionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.S3ExportConfiguration
  ): zio.aws.qldb.model.S3ExportConfiguration.ReadOnly = new Wrapper(impl)
}
