package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.LedgerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateLedgerPermissionsModeRequest(
    name: LedgerName,
    permissionsMode: zio.aws.qldb.model.PermissionsMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeRequest = {
    import UpdateLedgerPermissionsModeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .permissionsMode(permissionsMode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest.ReadOnly =
    zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest.wrap(buildAwsValue())
}
object UpdateLedgerPermissionsModeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest =
      zio.aws.qldb.model
        .UpdateLedgerPermissionsModeRequest(name, permissionsMode)
    def name: LedgerName
    def permissionsMode: zio.aws.qldb.model.PermissionsMode
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
    def getPermissionsMode
        : ZIO[Any, Nothing, zio.aws.qldb.model.PermissionsMode] =
      ZIO.succeed(permissionsMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeRequest
  ) extends zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
    override val permissionsMode: zio.aws.qldb.model.PermissionsMode =
      zio.aws.qldb.model.PermissionsMode.wrap(impl.permissionsMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeRequest
  ): zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest.ReadOnly =
    new Wrapper(impl)
}
