package zio.aws.qldb
import zio.aws.core.config.AwsConfig
import zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.ReadOnly
import software.amazon.awssdk.services.qldb.{
  QldbAsyncClientBuilder,
  QldbAsyncClient
}
import software.amazon.awssdk.services.qldb.model.{
  UpdateLedgerPermissionsModeRequest,
  DescribeJournalKinesisStreamRequest,
  DeleteLedgerRequest,
  ListJournalKinesisStreamsForLedgerRequest,
  DescribeLedgerResponse,
  GetDigestResponse,
  ListTagsForResourceRequest,
  ExportJournalToS3Request,
  JournalS3ExportDescription,
  GetRevisionRequest,
  ListJournalS3ExportsRequest,
  StreamJournalToKinesisResponse,
  JournalKinesisStreamDescription,
  ExportJournalToS3Response,
  UpdateLedgerResponse,
  ListJournalKinesisStreamsForLedgerResponse,
  CancelJournalKinesisStreamRequest,
  ListTagsForResourceResponse,
  ListJournalS3ExportsResponse,
  UntagResourceResponse,
  GetBlockResponse,
  ListJournalS3ExportsForLedgerRequest,
  CreateLedgerResponse,
  ListLedgersRequest,
  DeleteLedgerResponse,
  CancelJournalKinesisStreamResponse,
  StreamJournalToKinesisRequest,
  UpdateLedgerRequest,
  GetRevisionResponse,
  GetBlockRequest,
  UntagResourceRequest,
  ListJournalS3ExportsForLedgerResponse,
  UpdateLedgerPermissionsModeResponse,
  DescribeJournalKinesisStreamResponse,
  ListLedgersResponse,
  GetDigestRequest,
  DescribeLedgerRequest,
  DescribeJournalS3ExportResponse,
  TagResourceResponse,
  DescribeJournalS3ExportRequest,
  LedgerSummary,
  TagResourceRequest,
  CreateLedgerRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Qldb extends AspectSupport[Qldb] {
  val api: QldbAsyncClient
  def describeLedger(
      request: zio.aws.qldb.model.DescribeLedgerRequest
  ): IO[AwsError, zio.aws.qldb.model.DescribeLedgerResponse.ReadOnly]
  def updateLedgerPermissionsMode(
      request: zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest
  ): IO[
    AwsError,
    zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly
  ]
  def getBlock(
      request: zio.aws.qldb.model.GetBlockRequest
  ): IO[AwsError, zio.aws.qldb.model.GetBlockResponse.ReadOnly]
  def streamJournalToKinesis(
      request: zio.aws.qldb.model.StreamJournalToKinesisRequest
  ): IO[AwsError, zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly]
  def listJournalS3Exports(
      request: zio.aws.qldb.model.ListJournalS3ExportsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
  ]
  def listJournalS3ExportsPaginated(
      request: zio.aws.qldb.model.ListJournalS3ExportsRequest
  ): IO[AwsError, zio.aws.qldb.model.ListJournalS3ExportsResponse.ReadOnly]
  def cancelJournalKinesisStream(
      request: zio.aws.qldb.model.CancelJournalKinesisStreamRequest
  ): IO[
    AwsError,
    zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly
  ]
  def listJournalS3ExportsForLedger(
      request: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
  ]
  def listJournalS3ExportsForLedgerPaginated(
      request: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
  ): IO[
    AwsError,
    zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly
  ]
  def listJournalKinesisStreamsForLedger(
      request: zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
  ]
  def listJournalKinesisStreamsForLedgerPaginated(
      request: zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ): IO[AwsError, ReadOnly]
  def deleteLedger(
      request: zio.aws.qldb.model.DeleteLedgerRequest
  ): IO[AwsError, Unit]
  def createLedger(
      request: zio.aws.qldb.model.CreateLedgerRequest
  ): IO[AwsError, zio.aws.qldb.model.CreateLedgerResponse.ReadOnly]
  def untagResource(
      request: zio.aws.qldb.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.qldb.model.UntagResourceResponse.ReadOnly]
  def getRevision(
      request: zio.aws.qldb.model.GetRevisionRequest
  ): IO[AwsError, zio.aws.qldb.model.GetRevisionResponse.ReadOnly]
  def getDigest(
      request: zio.aws.qldb.model.GetDigestRequest
  ): IO[AwsError, zio.aws.qldb.model.GetDigestResponse.ReadOnly]
  def updateLedger(
      request: zio.aws.qldb.model.UpdateLedgerRequest
  ): IO[AwsError, zio.aws.qldb.model.UpdateLedgerResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.qldb.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.qldb.model.ListTagsForResourceResponse.ReadOnly]
  def listLedgers(
      request: zio.aws.qldb.model.ListLedgersRequest
  ): ZStream[Any, AwsError, zio.aws.qldb.model.LedgerSummary.ReadOnly]
  def listLedgersPaginated(
      request: zio.aws.qldb.model.ListLedgersRequest
  ): IO[AwsError, zio.aws.qldb.model.ListLedgersResponse.ReadOnly]
  def tagResource(
      request: zio.aws.qldb.model.TagResourceRequest
  ): IO[AwsError, zio.aws.qldb.model.TagResourceResponse.ReadOnly]
  def describeJournalS3Export(
      request: zio.aws.qldb.model.DescribeJournalS3ExportRequest
  ): IO[AwsError, zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly]
  def exportJournalToS3(
      request: zio.aws.qldb.model.ExportJournalToS3Request
  ): IO[AwsError, zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly]
  def describeJournalKinesisStream(
      request: zio.aws.qldb.model.DescribeJournalKinesisStreamRequest
  ): IO[
    AwsError,
    zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly
  ]
}
object Qldb {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Qldb] = customized(identity)
  def customized(
      customization: QldbAsyncClientBuilder => QldbAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Qldb] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: QldbAsyncClientBuilder => QldbAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Qldb] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = QldbAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[QldbAsyncClient, QldbAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[QldbAsyncClient, QldbAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new QldbImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class QldbImpl[R](
      override val api: QldbAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Qldb
      with AwsServiceBase[R] {
    override val serviceName: String = "Qldb"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): QldbImpl[R1] = new QldbImpl(api, newAspect, r)
    def describeLedger(
        request: zio.aws.qldb.model.DescribeLedgerRequest
    ): IO[AwsError, zio.aws.qldb.model.DescribeLedgerResponse.ReadOnly] =
      asyncRequestResponse[DescribeLedgerRequest, DescribeLedgerResponse](
        "describeLedger",
        api.describeLedger
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.DescribeLedgerResponse.wrap)
        .provideEnvironment(r)
    def updateLedgerPermissionsMode(
        request: zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest
    ): IO[
      AwsError,
      zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateLedgerPermissionsModeRequest,
      UpdateLedgerPermissionsModeResponse
    ]("updateLedgerPermissionsMode", api.updateLedgerPermissionsMode)(
      request.buildAwsValue()
    ).map(zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.wrap)
      .provideEnvironment(r)
    def getBlock(
        request: zio.aws.qldb.model.GetBlockRequest
    ): IO[AwsError, zio.aws.qldb.model.GetBlockResponse.ReadOnly] =
      asyncRequestResponse[GetBlockRequest, GetBlockResponse](
        "getBlock",
        api.getBlock
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.GetBlockResponse.wrap)
        .provideEnvironment(r)
    def streamJournalToKinesis(
        request: zio.aws.qldb.model.StreamJournalToKinesisRequest
    ): IO[
      AwsError,
      zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly
    ] = asyncRequestResponse[
      StreamJournalToKinesisRequest,
      StreamJournalToKinesisResponse
    ]("streamJournalToKinesis", api.streamJournalToKinesis)(
      request.buildAwsValue()
    ).map(zio.aws.qldb.model.StreamJournalToKinesisResponse.wrap)
      .provideEnvironment(r)
    def listJournalS3Exports(
        request: zio.aws.qldb.model.ListJournalS3ExportsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListJournalS3ExportsRequest,
      ListJournalS3ExportsResponse,
      JournalS3ExportDescription
    ](
      "listJournalS3Exports",
      api.listJournalS3Exports,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.journalS3Exports().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.qldb.model.JournalS3ExportDescription.wrap(item))
      .provideEnvironment(r)
    def listJournalS3ExportsPaginated(
        request: zio.aws.qldb.model.ListJournalS3ExportsRequest
    ): IO[AwsError, zio.aws.qldb.model.ListJournalS3ExportsResponse.ReadOnly] =
      asyncRequestResponse[
        ListJournalS3ExportsRequest,
        ListJournalS3ExportsResponse
      ]("listJournalS3Exports", api.listJournalS3Exports)(
        request.buildAwsValue()
      ).map(zio.aws.qldb.model.ListJournalS3ExportsResponse.wrap)
        .provideEnvironment(r)
    def cancelJournalKinesisStream(
        request: zio.aws.qldb.model.CancelJournalKinesisStreamRequest
    ): IO[
      AwsError,
      zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelJournalKinesisStreamRequest,
      CancelJournalKinesisStreamResponse
    ]("cancelJournalKinesisStream", api.cancelJournalKinesisStream)(
      request.buildAwsValue()
    ).map(zio.aws.qldb.model.CancelJournalKinesisStreamResponse.wrap)
      .provideEnvironment(r)
    def listJournalS3ExportsForLedger(
        request: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListJournalS3ExportsForLedgerRequest,
      ListJournalS3ExportsForLedgerResponse,
      JournalS3ExportDescription
    ](
      "listJournalS3ExportsForLedger",
      api.listJournalS3ExportsForLedger,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.journalS3Exports().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.qldb.model.JournalS3ExportDescription.wrap(item))
      .provideEnvironment(r)
    def listJournalS3ExportsForLedgerPaginated(
        request: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
    ): IO[
      AwsError,
      zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly
    ] = asyncRequestResponse[
      ListJournalS3ExportsForLedgerRequest,
      ListJournalS3ExportsForLedgerResponse
    ]("listJournalS3ExportsForLedger", api.listJournalS3ExportsForLedger)(
      request.buildAwsValue()
    ).map(zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.wrap)
      .provideEnvironment(r)
    def listJournalKinesisStreamsForLedger(
        request: zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListJournalKinesisStreamsForLedgerRequest,
      ListJournalKinesisStreamsForLedgerResponse,
      JournalKinesisStreamDescription
    ](
      "listJournalKinesisStreamsForLedger",
      api.listJournalKinesisStreamsForLedger,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.streams().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.qldb.model.JournalKinesisStreamDescription.wrap(item)
      )
      .provideEnvironment(r)
    def listJournalKinesisStreamsForLedgerPaginated(
        request: zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListJournalKinesisStreamsForLedgerRequest,
      ListJournalKinesisStreamsForLedgerResponse
    ](
      "listJournalKinesisStreamsForLedger",
      api.listJournalKinesisStreamsForLedger
    )(request.buildAwsValue())
      .map(zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerResponse.wrap)
      .provideEnvironment(r)
    def deleteLedger(
        request: zio.aws.qldb.model.DeleteLedgerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteLedgerRequest, DeleteLedgerResponse](
        "deleteLedger",
        api.deleteLedger
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createLedger(
        request: zio.aws.qldb.model.CreateLedgerRequest
    ): IO[AwsError, zio.aws.qldb.model.CreateLedgerResponse.ReadOnly] =
      asyncRequestResponse[CreateLedgerRequest, CreateLedgerResponse](
        "createLedger",
        api.createLedger
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.CreateLedgerResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.qldb.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.qldb.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getRevision(
        request: zio.aws.qldb.model.GetRevisionRequest
    ): IO[AwsError, zio.aws.qldb.model.GetRevisionResponse.ReadOnly] =
      asyncRequestResponse[GetRevisionRequest, GetRevisionResponse](
        "getRevision",
        api.getRevision
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.GetRevisionResponse.wrap)
        .provideEnvironment(r)
    def getDigest(
        request: zio.aws.qldb.model.GetDigestRequest
    ): IO[AwsError, zio.aws.qldb.model.GetDigestResponse.ReadOnly] =
      asyncRequestResponse[GetDigestRequest, GetDigestResponse](
        "getDigest",
        api.getDigest
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.GetDigestResponse.wrap)
        .provideEnvironment(r)
    def updateLedger(
        request: zio.aws.qldb.model.UpdateLedgerRequest
    ): IO[AwsError, zio.aws.qldb.model.UpdateLedgerResponse.ReadOnly] =
      asyncRequestResponse[UpdateLedgerRequest, UpdateLedgerResponse](
        "updateLedger",
        api.updateLedger
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.UpdateLedgerResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.qldb.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.qldb.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.qldb.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def listLedgers(
        request: zio.aws.qldb.model.ListLedgersRequest
    ): ZStream[Any, AwsError, zio.aws.qldb.model.LedgerSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListLedgersRequest,
        ListLedgersResponse,
        LedgerSummary
      ](
        "listLedgers",
        api.listLedgers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ledgers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.qldb.model.LedgerSummary.wrap(item))
        .provideEnvironment(r)
    def listLedgersPaginated(
        request: zio.aws.qldb.model.ListLedgersRequest
    ): IO[AwsError, zio.aws.qldb.model.ListLedgersResponse.ReadOnly] =
      asyncRequestResponse[ListLedgersRequest, ListLedgersResponse](
        "listLedgers",
        api.listLedgers
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.ListLedgersResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.qldb.model.TagResourceRequest
    ): IO[AwsError, zio.aws.qldb.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeJournalS3Export(
        request: zio.aws.qldb.model.DescribeJournalS3ExportRequest
    ): IO[
      AwsError,
      zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeJournalS3ExportRequest,
      DescribeJournalS3ExportResponse
    ]("describeJournalS3Export", api.describeJournalS3Export)(
      request.buildAwsValue()
    ).map(zio.aws.qldb.model.DescribeJournalS3ExportResponse.wrap)
      .provideEnvironment(r)
    def exportJournalToS3(
        request: zio.aws.qldb.model.ExportJournalToS3Request
    ): IO[AwsError, zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly] =
      asyncRequestResponse[ExportJournalToS3Request, ExportJournalToS3Response](
        "exportJournalToS3",
        api.exportJournalToS3
      )(request.buildAwsValue())
        .map(zio.aws.qldb.model.ExportJournalToS3Response.wrap)
        .provideEnvironment(r)
    def describeJournalKinesisStream(
        request: zio.aws.qldb.model.DescribeJournalKinesisStreamRequest
    ): IO[
      AwsError,
      zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeJournalKinesisStreamRequest,
      DescribeJournalKinesisStreamResponse
    ]("describeJournalKinesisStream", api.describeJournalKinesisStream)(
      request.buildAwsValue()
    ).map(zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.wrap)
      .provideEnvironment(r)
  }
  def describeLedger(request: zio.aws.qldb.model.DescribeLedgerRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.DescribeLedgerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLedger(request))
  def updateLedgerPermissionsMode(
      request: zio.aws.qldb.model.UpdateLedgerPermissionsModeRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.UpdateLedgerPermissionsModeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLedgerPermissionsMode(request))
  def getBlock(request: zio.aws.qldb.model.GetBlockRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.GetBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBlock(request))
  def streamJournalToKinesis(
      request: zio.aws.qldb.model.StreamJournalToKinesisRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.StreamJournalToKinesisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.streamJournalToKinesis(request))
  def listJournalS3Exports(
      request: zio.aws.qldb.model.ListJournalS3ExportsRequest
  ): ZStream[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listJournalS3Exports(request))
  def listJournalS3ExportsPaginated(
      request: zio.aws.qldb.model.ListJournalS3ExportsRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.ListJournalS3ExportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJournalS3ExportsPaginated(request))
  def cancelJournalKinesisStream(
      request: zio.aws.qldb.model.CancelJournalKinesisStreamRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.CancelJournalKinesisStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJournalKinesisStream(request))
  def listJournalS3ExportsForLedger(
      request: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
  ): ZStream[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listJournalS3ExportsForLedger(request))
  def listJournalS3ExportsForLedgerPaginated(
      request: zio.aws.qldb.model.ListJournalS3ExportsForLedgerRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.ListJournalS3ExportsForLedgerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJournalS3ExportsForLedgerPaginated(request))
  def listJournalKinesisStreamsForLedger(
      request: zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ): ZStream[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listJournalKinesisStreamsForLedger(request))
  def listJournalKinesisStreamsForLedgerPaginated(
      request: zio.aws.qldb.model.ListJournalKinesisStreamsForLedgerRequest
  ): ZIO[zio.aws.qldb.Qldb, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listJournalKinesisStreamsForLedgerPaginated(request))
  def deleteLedger(
      request: zio.aws.qldb.model.DeleteLedgerRequest
  ): ZIO[zio.aws.qldb.Qldb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLedger(request))
  def createLedger(request: zio.aws.qldb.model.CreateLedgerRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.CreateLedgerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLedger(request))
  def untagResource(request: zio.aws.qldb.model.UntagResourceRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getRevision(request: zio.aws.qldb.model.GetRevisionRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.GetRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRevision(request))
  def getDigest(request: zio.aws.qldb.model.GetDigestRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.GetDigestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDigest(request))
  def updateLedger(request: zio.aws.qldb.model.UpdateLedgerRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.UpdateLedgerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLedger(request))
  def listTagsForResource(
      request: zio.aws.qldb.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listLedgers(request: zio.aws.qldb.model.ListLedgersRequest): ZStream[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.LedgerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLedgers(request))
  def listLedgersPaginated(request: zio.aws.qldb.model.ListLedgersRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.ListLedgersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLedgersPaginated(request))
  def tagResource(request: zio.aws.qldb.model.TagResourceRequest): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeJournalS3Export(
      request: zio.aws.qldb.model.DescribeJournalS3ExportRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJournalS3Export(request))
  def exportJournalToS3(
      request: zio.aws.qldb.model.ExportJournalToS3Request
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.ExportJournalToS3Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportJournalToS3(request))
  def describeJournalKinesisStream(
      request: zio.aws.qldb.model.DescribeJournalKinesisStreamRequest
  ): ZIO[
    zio.aws.qldb.Qldb,
    AwsError,
    zio.aws.qldb.model.DescribeJournalKinesisStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJournalKinesisStream(request))
}
