package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.LedgerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLedgerRequest(name: LedgerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest = {
    import DeleteLedgerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest
      .builder()
      .name(LedgerName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.DeleteLedgerRequest.ReadOnly =
    zio.aws.qldb.model.DeleteLedgerRequest.wrap(buildAwsValue())
}
object DeleteLedgerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.DeleteLedgerRequest =
      zio.aws.qldb.model.DeleteLedgerRequest(name)
    def name: LedgerName
    def getName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest
  ) extends zio.aws.qldb.model.DeleteLedgerRequest.ReadOnly {
    override val name: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest
  ): zio.aws.qldb.model.DeleteLedgerRequest.ReadOnly = new Wrapper(impl)
}
