package zio.aws.qldb.model
import zio.ZIO
import zio.aws.qldb.model.primitives.{TagValue, TagKey, Arn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.TagResourceRequest.ReadOnly =
    zio.aws.qldb.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.TagResourceRequest =
      zio.aws.qldb.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.TagResourceRequest
  ) extends zio.aws.qldb.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.qldb.model.primitives
          .TagKey(key) -> zio.aws.qldb.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.TagResourceRequest
  ): zio.aws.qldb.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
