package zio.aws.qldb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeJournalS3ExportResponse(
    exportDescription: zio.aws.qldb.model.JournalS3ExportDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse = {
    import DescribeJournalS3ExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse
      .builder()
      .exportDescription(exportDescription.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly =
    zio.aws.qldb.model.DescribeJournalS3ExportResponse.wrap(buildAwsValue())
}
object DescribeJournalS3ExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.DescribeJournalS3ExportResponse =
      zio.aws.qldb.model
        .DescribeJournalS3ExportResponse(exportDescription.asEditable)
    def exportDescription
        : zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
    def getExportDescription: ZIO[
      Any,
      Nothing,
      zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly
    ] = ZIO.succeed(exportDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse
  ) extends zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly {
    override val exportDescription
        : zio.aws.qldb.model.JournalS3ExportDescription.ReadOnly =
      zio.aws.qldb.model.JournalS3ExportDescription
        .wrap(impl.exportDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse
  ): zio.aws.qldb.model.DescribeJournalS3ExportResponse.ReadOnly = new Wrapper(
    impl
  )
}
