package zio.aws.qldb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.qldb.model.primitives.{
  StreamName,
  Timestamp,
  Arn,
  LedgerName,
  UniqueId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class JournalKinesisStreamDescription(
    ledgerName: LedgerName,
    creationTime: Optional[Timestamp] = Optional.Absent,
    inclusiveStartTime: Optional[Timestamp] = Optional.Absent,
    exclusiveEndTime: Optional[Timestamp] = Optional.Absent,
    roleArn: Arn,
    streamId: UniqueId,
    arn: Optional[Arn] = Optional.Absent,
    status: zio.aws.qldb.model.StreamStatus,
    kinesisConfiguration: zio.aws.qldb.model.KinesisConfiguration,
    errorCause: Optional[zio.aws.qldb.model.ErrorCause] = Optional.Absent,
    streamName: StreamName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription = {
    import JournalKinesisStreamDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription
      .builder()
      .ledgerName(LedgerName.unwrap(ledgerName): java.lang.String)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        inclusiveStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.inclusiveStartTime)
      .optionallyWith(
        exclusiveEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.exclusiveEndTime)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .streamId(UniqueId.unwrap(streamId): java.lang.String)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .status(status.unwrap)
      .kinesisConfiguration(kinesisConfiguration.buildAwsValue())
      .optionallyWith(errorCause.map(value => value.unwrap))(_.errorCause)
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly =
    zio.aws.qldb.model.JournalKinesisStreamDescription.wrap(buildAwsValue())
}
object JournalKinesisStreamDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.qldb.model.JournalKinesisStreamDescription =
      zio.aws.qldb.model.JournalKinesisStreamDescription(
        ledgerName,
        creationTime.map(value => value),
        inclusiveStartTime.map(value => value),
        exclusiveEndTime.map(value => value),
        roleArn,
        streamId,
        arn.map(value => value),
        status,
        kinesisConfiguration.asEditable,
        errorCause.map(value => value),
        streamName
      )
    def ledgerName: LedgerName
    def creationTime: Optional[Timestamp]
    def inclusiveStartTime: Optional[Timestamp]
    def exclusiveEndTime: Optional[Timestamp]
    def roleArn: Arn
    def streamId: UniqueId
    def arn: Optional[Arn]
    def status: zio.aws.qldb.model.StreamStatus
    def kinesisConfiguration: zio.aws.qldb.model.KinesisConfiguration.ReadOnly
    def errorCause: Optional[zio.aws.qldb.model.ErrorCause]
    def streamName: StreamName
    def getLedgerName: ZIO[Any, Nothing, LedgerName] = ZIO.succeed(ledgerName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getInclusiveStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("inclusiveStartTime", inclusiveStartTime)
    def getExclusiveEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("exclusiveEndTime", exclusiveEndTime)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getStreamId: ZIO[Any, Nothing, UniqueId] = ZIO.succeed(streamId)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, Nothing, zio.aws.qldb.model.StreamStatus] =
      ZIO.succeed(status)
    def getKinesisConfiguration
        : ZIO[Any, Nothing, zio.aws.qldb.model.KinesisConfiguration.ReadOnly] =
      ZIO.succeed(kinesisConfiguration)
    def getErrorCause: ZIO[Any, AwsError, zio.aws.qldb.model.ErrorCause] =
      AwsError.unwrapOptionField("errorCause", errorCause)
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription
  ) extends zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly {
    override val ledgerName: LedgerName =
      zio.aws.qldb.model.primitives.LedgerName(impl.ledgerName())
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
    override val inclusiveStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.inclusiveStartTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
    override val exclusiveEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusiveEndTime())
      .map(value => zio.aws.qldb.model.primitives.Timestamp(value))
    override val roleArn: Arn =
      zio.aws.qldb.model.primitives.Arn(impl.roleArn())
    override val streamId: UniqueId =
      zio.aws.qldb.model.primitives.UniqueId(impl.streamId())
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.qldb.model.primitives.Arn(value))
    override val status: zio.aws.qldb.model.StreamStatus =
      zio.aws.qldb.model.StreamStatus.wrap(impl.status())
    override val kinesisConfiguration
        : zio.aws.qldb.model.KinesisConfiguration.ReadOnly =
      zio.aws.qldb.model.KinesisConfiguration.wrap(impl.kinesisConfiguration())
    override val errorCause: Optional[zio.aws.qldb.model.ErrorCause] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCause())
        .map(value => zio.aws.qldb.model.ErrorCause.wrap(value))
    override val streamName: StreamName =
      zio.aws.qldb.model.primitives.StreamName(impl.streamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription
  ): zio.aws.qldb.model.JournalKinesisStreamDescription.ReadOnly = new Wrapper(
    impl
  )
}
