package zio.aws.qldb
import zio.aws.qldb.model.primitives.S3Bucket.Type
import java.time.Instant
import zio.aws.qldb.model.primitives.{TagValue, TagKey}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.qldb.model.primitives.Arn.Type
    object DeletionProtection extends zio.prelude.Subtype[Boolean]
    type DeletionProtection =
      zio.aws.qldb.model.primitives.DeletionProtection.Type
    object Digest extends zio.prelude.Subtype[Chunk[Byte]]
    type Digest = zio.aws.qldb.model.primitives.Digest.Type
    object IonText extends zio.prelude.Subtype[String]
    type IonText = zio.aws.qldb.model.primitives.IonText.Type
    object KmsKey extends zio.prelude.Subtype[String]
    type KmsKey = zio.aws.qldb.model.primitives.KmsKey.Type
    object LedgerName extends zio.prelude.Subtype[String]
    type LedgerName = zio.aws.qldb.model.primitives.LedgerName.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.qldb.model.primitives.MaxResults.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.qldb.model.primitives.NextToken.Type
    object S3Bucket extends zio.prelude.Subtype[String]
    type S3Bucket = zio.aws.qldb.model.primitives.S3Bucket.Type
    object S3Prefix extends zio.prelude.Subtype[String]
    type S3Prefix = zio.aws.qldb.model.primitives.S3Prefix.Type
    object StreamName extends zio.prelude.Subtype[String]
    type StreamName = zio.aws.qldb.model.primitives.StreamName.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.qldb.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.qldb.model.primitives.TagValue.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.qldb.model.primitives.Timestamp.Type
    object UniqueId extends zio.prelude.Subtype[String]
    type UniqueId = zio.aws.qldb.model.primitives.UniqueId.Type
  }
  type JournalKinesisStreamDescriptionList =
    List[zio.aws.qldb.model.JournalKinesisStreamDescription]
  type JournalS3ExportList = List[zio.aws.qldb.model.JournalS3ExportDescription]
  type LedgerList = List[zio.aws.qldb.model.LedgerSummary]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
