package zio.aws.ram
import zio.aws.ram.model.AssociateResourceShareResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.ram.model.{
  CreateResourceShareRequest,
  GetPermissionRequest,
  GetResourcePoliciesRequest,
  DisassociateResourceShareRequest,
  GetResourceSharesRequest,
  ListResourceTypesRequest,
  GetResourceShareInvitationsRequest,
  ListPendingInvitationResourcesRequest,
  EnableSharingWithAwsOrganizationRequest,
  ListResourceSharePermissionsRequest,
  ListResourcesRequest,
  AssociateResourceShareRequest,
  DisassociateResourceSharePermissionRequest,
  ListPermissionVersionsRequest,
  DeleteResourceShareRequest,
  ListPrincipalsRequest,
  PromoteResourceShareCreatedFromPolicyRequest,
  ListPermissionsRequest,
  UntagResourceRequest,
  RejectResourceShareInvitationRequest,
  AssociateResourceSharePermissionRequest,
  UpdateResourceShareRequest,
  AcceptResourceShareInvitationRequest,
  TagResourceRequest,
  GetResourceShareAssociationsRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.ram.model.{
  DisassociateResourceSharePermissionResponse,
  AcceptResourceShareInvitationResponse,
  AssociateResourceSharePermissionResponse,
  AssociateResourceShareResponse,
  ListResourceSharePermissionsResponse,
  RejectResourceShareInvitationResponse,
  ListResourceTypesResponse,
  ListResourcesResponse,
  ListPermissionVersionsResponse,
  UpdateResourceShareResponse,
  GetResourceSharesResponse,
  ListPermissionsResponse,
  UntagResourceResponse,
  GetResourcePoliciesResponse,
  GetPermissionResponse,
  EnableSharingWithAwsOrganizationResponse,
  ListPrincipalsResponse,
  GetResourceShareAssociationsResponse,
  PromoteResourceShareCreatedFromPolicyResponse,
  DeleteResourceShareResponse,
  DisassociateResourceShareResponse,
  CreateResourceShareResponse,
  ListPendingInvitationResourcesResponse,
  TagResourceResponse,
  GetResourceShareInvitationsResponse
}
import software.amazon.awssdk.services.ram.{
  RamAsyncClientBuilder,
  RamAsyncClient
}
import scala.jdk.CollectionConverters._
trait Ram extends AspectSupport[Ram] {
  val api: RamAsyncClient
  def getPermission(
      request: GetPermissionRequest
  ): IO[AwsError, zio.aws.ram.model.GetPermissionResponse.ReadOnly]
  def getResourceShares(
      request: GetResourceSharesRequest
  ): IO[AwsError, zio.aws.ram.model.GetResourceSharesResponse.ReadOnly]
  def listPendingInvitationResources(
      request: ListPendingInvitationResourcesRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly
  ]
  def disassociateResourceShare(
      request: DisassociateResourceShareRequest
  ): IO[AwsError, zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly]
  def updateResourceShare(
      request: UpdateResourceShareRequest
  ): IO[AwsError, zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly]
  def enableSharingWithAwsOrganization(
      request: EnableSharingWithAwsOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly
  ]
  def deleteResourceShare(
      request: DeleteResourceShareRequest
  ): IO[AwsError, zio.aws.ram.model.DeleteResourceShareResponse.ReadOnly]
  def rejectResourceShareInvitation(
      request: RejectResourceShareInvitationRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.RejectResourceShareInvitationResponse.ReadOnly
  ]
  def listResourceSharePermissions(
      request: ListResourceSharePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.ListResourceSharePermissionsResponse.ReadOnly
  ]
  def listResourceTypes(
      request: ListResourceTypesRequest
  ): IO[AwsError, zio.aws.ram.model.ListResourceTypesResponse.ReadOnly]
  def createResourceShare(
      request: CreateResourceShareRequest
  ): IO[AwsError, zio.aws.ram.model.CreateResourceShareResponse.ReadOnly]
  def associateResourceShare(
      request: AssociateResourceShareRequest
  ): IO[AwsError, ReadOnly]
  def disassociateResourceSharePermission(
      request: DisassociateResourceSharePermissionRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly
  ]
  def associateResourceSharePermission(
      request: AssociateResourceSharePermissionRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.ram.model.UntagResourceResponse.ReadOnly]
  def listResources(
      request: ListResourcesRequest
  ): IO[AwsError, zio.aws.ram.model.ListResourcesResponse.ReadOnly]
  def listPrincipals(
      request: ListPrincipalsRequest
  ): IO[AwsError, zio.aws.ram.model.ListPrincipalsResponse.ReadOnly]
  def getResourceShareInvitations(
      request: GetResourceShareInvitationsRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.ram.model.TagResourceResponse.ReadOnly]
  def getResourceShareAssociations(
      request: GetResourceShareAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly
  ]
  def listPermissions(
      request: ListPermissionsRequest
  ): IO[AwsError, zio.aws.ram.model.ListPermissionsResponse.ReadOnly]
  def promoteResourceShareCreatedFromPolicy(
      request: PromoteResourceShareCreatedFromPolicyRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly
  ]
  def acceptResourceShareInvitation(
      request: AcceptResourceShareInvitationRequest
  ): IO[
    AwsError,
    zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly
  ]
  def getResourcePolicies(
      request: GetResourcePoliciesRequest
  ): IO[AwsError, zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly]
  def listPermissionVersions(
      request: ListPermissionVersionsRequest
  ): IO[AwsError, zio.aws.ram.model.ListPermissionVersionsResponse.ReadOnly]
}
object Ram {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ram] = customized(identity)
  def customized(
      customization: RamAsyncClientBuilder => RamAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ram] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RamAsyncClientBuilder => RamAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Ram] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RamAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[RamAsyncClient, RamAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[RamAsyncClient, RamAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new RamImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RamImpl[R](
      override val api: RamAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ram
      with AwsServiceBase[R] {
    override val serviceName: String = "Ram"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RamImpl[R1] = new RamImpl(api, newAspect, r)
    def getPermission(
        request: GetPermissionRequest
    ): IO[AwsError, zio.aws.ram.model.GetPermissionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.GetPermissionRequest,
        GetPermissionResponse
      ]("getPermission", api.getPermission)(request.buildAwsValue())
        .map(zio.aws.ram.model.GetPermissionResponse.wrap)
        .provideEnvironment(r)
    def getResourceShares(
        request: GetResourceSharesRequest
    ): IO[AwsError, zio.aws.ram.model.GetResourceSharesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.GetResourceSharesRequest,
        GetResourceSharesResponse
      ]("getResourceShares", api.getResourceShares)(request.buildAwsValue())
        .map(zio.aws.ram.model.GetResourceSharesResponse.wrap)
        .provideEnvironment(r)
    def listPendingInvitationResources(
        request: ListPendingInvitationResourcesRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest,
      ListPendingInvitationResourcesResponse
    ]("listPendingInvitationResources", api.listPendingInvitationResources)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.ListPendingInvitationResourcesResponse.wrap)
      .provideEnvironment(r)
    def disassociateResourceShare(
        request: DisassociateResourceShareRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest,
      DisassociateResourceShareResponse
    ]("disassociateResourceShare", api.disassociateResourceShare)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.DisassociateResourceShareResponse.wrap)
      .provideEnvironment(r)
    def updateResourceShare(
        request: UpdateResourceShareRequest
    ): IO[AwsError, zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest,
        UpdateResourceShareResponse
      ]("updateResourceShare", api.updateResourceShare)(request.buildAwsValue())
        .map(zio.aws.ram.model.UpdateResourceShareResponse.wrap)
        .provideEnvironment(r)
    def enableSharingWithAwsOrganization(
        request: EnableSharingWithAwsOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest,
      EnableSharingWithAwsOrganizationResponse
    ]("enableSharingWithAwsOrganization", api.enableSharingWithAwsOrganization)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.wrap)
      .provideEnvironment(r)
    def deleteResourceShare(
        request: DeleteResourceShareRequest
    ): IO[AwsError, zio.aws.ram.model.DeleteResourceShareResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest,
        DeleteResourceShareResponse
      ]("deleteResourceShare", api.deleteResourceShare)(request.buildAwsValue())
        .map(zio.aws.ram.model.DeleteResourceShareResponse.wrap)
        .provideEnvironment(r)
    def rejectResourceShareInvitation(
        request: RejectResourceShareInvitationRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.RejectResourceShareInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest,
      RejectResourceShareInvitationResponse
    ]("rejectResourceShareInvitation", api.rejectResourceShareInvitation)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.RejectResourceShareInvitationResponse.wrap)
      .provideEnvironment(r)
    def listResourceSharePermissions(
        request: ListResourceSharePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.ListResourceSharePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest,
      ListResourceSharePermissionsResponse
    ]("listResourceSharePermissions", api.listResourceSharePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.ListResourceSharePermissionsResponse.wrap)
      .provideEnvironment(r)
    def listResourceTypes(
        request: ListResourceTypesRequest
    ): IO[AwsError, zio.aws.ram.model.ListResourceTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.ListResourceTypesRequest,
        ListResourceTypesResponse
      ]("listResourceTypes", api.listResourceTypes)(request.buildAwsValue())
        .map(zio.aws.ram.model.ListResourceTypesResponse.wrap)
        .provideEnvironment(r)
    def createResourceShare(
        request: CreateResourceShareRequest
    ): IO[AwsError, zio.aws.ram.model.CreateResourceShareResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.CreateResourceShareRequest,
        CreateResourceShareResponse
      ]("createResourceShare", api.createResourceShare)(request.buildAwsValue())
        .map(zio.aws.ram.model.CreateResourceShareResponse.wrap)
        .provideEnvironment(r)
    def associateResourceShare(
        request: AssociateResourceShareRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest,
      AssociateResourceShareResponse
    ]("associateResourceShare", api.associateResourceShare)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.AssociateResourceShareResponse.wrap)
      .provideEnvironment(r)
    def disassociateResourceSharePermission(
        request: DisassociateResourceSharePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest,
      DisassociateResourceSharePermissionResponse
    ](
      "disassociateResourceSharePermission",
      api.disassociateResourceSharePermission
    )(request.buildAwsValue())
      .map(zio.aws.ram.model.DisassociateResourceSharePermissionResponse.wrap)
      .provideEnvironment(r)
    def associateResourceSharePermission(
        request: AssociateResourceSharePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest,
      AssociateResourceSharePermissionResponse
    ]("associateResourceSharePermission", api.associateResourceSharePermission)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.AssociateResourceSharePermissionResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.ram.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.ram.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listResources(
        request: ListResourcesRequest
    ): IO[AwsError, zio.aws.ram.model.ListResourcesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.ListResourcesRequest,
        ListResourcesResponse
      ]("listResources", api.listResources)(request.buildAwsValue())
        .map(zio.aws.ram.model.ListResourcesResponse.wrap)
        .provideEnvironment(r)
    def listPrincipals(
        request: ListPrincipalsRequest
    ): IO[AwsError, zio.aws.ram.model.ListPrincipalsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.ListPrincipalsRequest,
        ListPrincipalsResponse
      ]("listPrincipals", api.listPrincipals)(request.buildAwsValue())
        .map(zio.aws.ram.model.ListPrincipalsResponse.wrap)
        .provideEnvironment(r)
    def getResourceShareInvitations(
        request: GetResourceShareInvitationsRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest,
      GetResourceShareInvitationsResponse
    ]("getResourceShareInvitations", api.getResourceShareInvitations)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.GetResourceShareInvitationsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.ram.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.ram.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getResourceShareAssociations(
        request: GetResourceShareAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest,
      GetResourceShareAssociationsResponse
    ]("getResourceShareAssociations", api.getResourceShareAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.GetResourceShareAssociationsResponse.wrap)
      .provideEnvironment(r)
    def listPermissions(
        request: ListPermissionsRequest
    ): IO[AwsError, zio.aws.ram.model.ListPermissionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.ListPermissionsRequest,
        ListPermissionsResponse
      ]("listPermissions", api.listPermissions)(request.buildAwsValue())
        .map(zio.aws.ram.model.ListPermissionsResponse.wrap)
        .provideEnvironment(r)
    def promoteResourceShareCreatedFromPolicy(
        request: PromoteResourceShareCreatedFromPolicyRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest,
      PromoteResourceShareCreatedFromPolicyResponse
    ](
      "promoteResourceShareCreatedFromPolicy",
      api.promoteResourceShareCreatedFromPolicy
    )(request.buildAwsValue())
      .map(zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.wrap)
      .provideEnvironment(r)
    def acceptResourceShareInvitation(
        request: AcceptResourceShareInvitationRequest
    ): IO[
      AwsError,
      zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest,
      AcceptResourceShareInvitationResponse
    ]("acceptResourceShareInvitation", api.acceptResourceShareInvitation)(
      request.buildAwsValue()
    ).map(zio.aws.ram.model.AcceptResourceShareInvitationResponse.wrap)
      .provideEnvironment(r)
    def getResourcePolicies(
        request: GetResourcePoliciesRequest
    ): IO[AwsError, zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest,
        GetResourcePoliciesResponse
      ]("getResourcePolicies", api.getResourcePolicies)(request.buildAwsValue())
        .map(zio.aws.ram.model.GetResourcePoliciesResponse.wrap)
        .provideEnvironment(r)
    def listPermissionVersions(
        request: ListPermissionVersionsRequest
    ): IO[AwsError, zio.aws.ram.model.ListPermissionVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest,
        ListPermissionVersionsResponse
      ]("listPermissionVersions", api.listPermissionVersions)(
        request.buildAwsValue()
      ).map(zio.aws.ram.model.ListPermissionVersionsResponse.wrap)
        .provideEnvironment(r)
  }
  def getPermission(request: GetPermissionRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.GetPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPermission(request))
  def getResourceShares(request: GetResourceSharesRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.GetResourceSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceShares(request))
  def listPendingInvitationResources(
      request: ListPendingInvitationResourcesRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPendingInvitationResources(request))
  def disassociateResourceShare(request: DisassociateResourceShareRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateResourceShare(request))
  def updateResourceShare(request: UpdateResourceShareRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResourceShare(request))
  def enableSharingWithAwsOrganization(
      request: EnableSharingWithAwsOrganizationRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableSharingWithAwsOrganization(request))
  def deleteResourceShare(request: DeleteResourceShareRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.DeleteResourceShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourceShare(request))
  def rejectResourceShareInvitation(
      request: RejectResourceShareInvitationRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.RejectResourceShareInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectResourceShareInvitation(request))
  def listResourceSharePermissions(
      request: ListResourceSharePermissionsRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListResourceSharePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceSharePermissions(request))
  def listResourceTypes(request: ListResourceTypesRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListResourceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceTypes(request))
  def createResourceShare(request: CreateResourceShareRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.CreateResourceShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResourceShare(request))
  def associateResourceShare(
      request: AssociateResourceShareRequest
  ): ZIO[zio.aws.ram.Ram, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.associateResourceShare(request))
  def disassociateResourceSharePermission(
      request: DisassociateResourceSharePermissionRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateResourceSharePermission(request))
  def associateResourceSharePermission(
      request: AssociateResourceSharePermissionRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateResourceSharePermission(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listResources(request: ListResourcesRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResources(request))
  def listPrincipals(request: ListPrincipalsRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListPrincipalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPrincipals(request))
  def getResourceShareInvitations(
      request: GetResourceShareInvitationsRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceShareInvitations(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getResourceShareAssociations(
      request: GetResourceShareAssociationsRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceShareAssociations(request))
  def listPermissions(request: ListPermissionsRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissions(request))
  def promoteResourceShareCreatedFromPolicy(
      request: PromoteResourceShareCreatedFromPolicyRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.promoteResourceShareCreatedFromPolicy(request))
  def acceptResourceShareInvitation(
      request: AcceptResourceShareInvitationRequest
  ): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptResourceShareInvitation(request))
  def getResourcePolicies(request: GetResourcePoliciesRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicies(request))
  def listPermissionVersions(request: ListPermissionVersionsRequest): ZIO[
    zio.aws.ram.Ram,
    AwsError,
    zio.aws.ram.model.ListPermissionVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionVersions(request))
}
