package zio.aws.ram
import zio.aws.ram.model.AssociateResourceShareResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.ram.model.{
  CreateResourceShareRequest,
  GetPermissionRequest,
  GetResourcePoliciesRequest,
  DisassociateResourceShareRequest,
  GetResourceSharesRequest,
  ListResourceTypesRequest,
  GetResourceShareInvitationsRequest,
  ListPendingInvitationResourcesRequest,
  EnableSharingWithAwsOrganizationRequest,
  ListResourceSharePermissionsRequest,
  ListResourcesRequest,
  AssociateResourceShareRequest,
  DisassociateResourceSharePermissionRequest,
  ListPermissionVersionsRequest,
  DeleteResourceShareRequest,
  ListPrincipalsRequest,
  PromoteResourceShareCreatedFromPolicyRequest,
  ListPermissionsRequest,
  UntagResourceRequest,
  RejectResourceShareInvitationRequest,
  AssociateResourceSharePermissionRequest,
  UpdateResourceShareRequest,
  AcceptResourceShareInvitationRequest,
  TagResourceRequest,
  GetResourceShareAssociationsRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.ram.RamAsyncClient
object RamMock extends Mock[Ram] {
  object GetPermission
      extends Effect[
        GetPermissionRequest,
        AwsError,
        zio.aws.ram.model.GetPermissionResponse.ReadOnly
      ]
  object GetResourceShares
      extends Effect[
        GetResourceSharesRequest,
        AwsError,
        zio.aws.ram.model.GetResourceSharesResponse.ReadOnly
      ]
  object ListPendingInvitationResources
      extends Effect[
        ListPendingInvitationResourcesRequest,
        AwsError,
        zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly
      ]
  object DisassociateResourceShare
      extends Effect[
        DisassociateResourceShareRequest,
        AwsError,
        zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly
      ]
  object UpdateResourceShare
      extends Effect[
        UpdateResourceShareRequest,
        AwsError,
        zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly
      ]
  object EnableSharingWithAwsOrganization
      extends Effect[
        EnableSharingWithAwsOrganizationRequest,
        AwsError,
        zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly
      ]
  object DeleteResourceShare
      extends Effect[
        DeleteResourceShareRequest,
        AwsError,
        zio.aws.ram.model.DeleteResourceShareResponse.ReadOnly
      ]
  object RejectResourceShareInvitation
      extends Effect[
        RejectResourceShareInvitationRequest,
        AwsError,
        zio.aws.ram.model.RejectResourceShareInvitationResponse.ReadOnly
      ]
  object ListResourceSharePermissions
      extends Effect[
        ListResourceSharePermissionsRequest,
        AwsError,
        zio.aws.ram.model.ListResourceSharePermissionsResponse.ReadOnly
      ]
  object ListResourceTypes
      extends Effect[
        ListResourceTypesRequest,
        AwsError,
        zio.aws.ram.model.ListResourceTypesResponse.ReadOnly
      ]
  object CreateResourceShare
      extends Effect[
        CreateResourceShareRequest,
        AwsError,
        zio.aws.ram.model.CreateResourceShareResponse.ReadOnly
      ]
  object AssociateResourceShare
      extends Effect[AssociateResourceShareRequest, AwsError, ReadOnly]
  object DisassociateResourceSharePermission
      extends Effect[
        DisassociateResourceSharePermissionRequest,
        AwsError,
        zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly
      ]
  object AssociateResourceSharePermission
      extends Effect[
        AssociateResourceSharePermissionRequest,
        AwsError,
        zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ram.model.UntagResourceResponse.ReadOnly
      ]
  object ListResources
      extends Effect[
        ListResourcesRequest,
        AwsError,
        zio.aws.ram.model.ListResourcesResponse.ReadOnly
      ]
  object ListPrincipals
      extends Effect[
        ListPrincipalsRequest,
        AwsError,
        zio.aws.ram.model.ListPrincipalsResponse.ReadOnly
      ]
  object GetResourceShareInvitations
      extends Effect[
        GetResourceShareInvitationsRequest,
        AwsError,
        zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ram.model.TagResourceResponse.ReadOnly
      ]
  object GetResourceShareAssociations
      extends Effect[
        GetResourceShareAssociationsRequest,
        AwsError,
        zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly
      ]
  object ListPermissions
      extends Effect[
        ListPermissionsRequest,
        AwsError,
        zio.aws.ram.model.ListPermissionsResponse.ReadOnly
      ]
  object PromoteResourceShareCreatedFromPolicy
      extends Effect[
        PromoteResourceShareCreatedFromPolicyRequest,
        AwsError,
        zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly
      ]
  object AcceptResourceShareInvitation
      extends Effect[
        AcceptResourceShareInvitationRequest,
        AwsError,
        zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly
      ]
  object GetResourcePolicies
      extends Effect[
        GetResourcePoliciesRequest,
        AwsError,
        zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly
      ]
  object ListPermissionVersions
      extends Effect[
        ListPermissionVersionsRequest,
        AwsError,
        zio.aws.ram.model.ListPermissionVersionsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ram] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Ram {
          val api: RamAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Ram = this
          def getPermission(
              request: GetPermissionRequest
          ): IO[AwsError, zio.aws.ram.model.GetPermissionResponse.ReadOnly] =
            proxy(GetPermission, request)
          def getResourceShares(request: GetResourceSharesRequest): IO[
            AwsError,
            zio.aws.ram.model.GetResourceSharesResponse.ReadOnly
          ] = proxy(GetResourceShares, request)
          def listPendingInvitationResources(
              request: ListPendingInvitationResourcesRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly
          ] = proxy(ListPendingInvitationResources, request)
          def disassociateResourceShare(
              request: DisassociateResourceShareRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly
          ] = proxy(DisassociateResourceShare, request)
          def updateResourceShare(request: UpdateResourceShareRequest): IO[
            AwsError,
            zio.aws.ram.model.UpdateResourceShareResponse.ReadOnly
          ] = proxy(UpdateResourceShare, request)
          def enableSharingWithAwsOrganization(
              request: EnableSharingWithAwsOrganizationRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly
          ] = proxy(EnableSharingWithAwsOrganization, request)
          def deleteResourceShare(request: DeleteResourceShareRequest): IO[
            AwsError,
            zio.aws.ram.model.DeleteResourceShareResponse.ReadOnly
          ] = proxy(DeleteResourceShare, request)
          def rejectResourceShareInvitation(
              request: RejectResourceShareInvitationRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.RejectResourceShareInvitationResponse.ReadOnly
          ] = proxy(RejectResourceShareInvitation, request)
          def listResourceSharePermissions(
              request: ListResourceSharePermissionsRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.ListResourceSharePermissionsResponse.ReadOnly
          ] = proxy(ListResourceSharePermissions, request)
          def listResourceTypes(request: ListResourceTypesRequest): IO[
            AwsError,
            zio.aws.ram.model.ListResourceTypesResponse.ReadOnly
          ] = proxy(ListResourceTypes, request)
          def createResourceShare(request: CreateResourceShareRequest): IO[
            AwsError,
            zio.aws.ram.model.CreateResourceShareResponse.ReadOnly
          ] = proxy(CreateResourceShare, request)
          def associateResourceShare(
              request: AssociateResourceShareRequest
          ): IO[AwsError, ReadOnly] = proxy(AssociateResourceShare, request)
          def disassociateResourceSharePermission(
              request: DisassociateResourceSharePermissionRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly
          ] = proxy(DisassociateResourceSharePermission, request)
          def associateResourceSharePermission(
              request: AssociateResourceSharePermissionRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly
          ] = proxy(AssociateResourceSharePermission, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.ram.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def listResources(
              request: ListResourcesRequest
          ): IO[AwsError, zio.aws.ram.model.ListResourcesResponse.ReadOnly] =
            proxy(ListResources, request)
          def listPrincipals(
              request: ListPrincipalsRequest
          ): IO[AwsError, zio.aws.ram.model.ListPrincipalsResponse.ReadOnly] =
            proxy(ListPrincipals, request)
          def getResourceShareInvitations(
              request: GetResourceShareInvitationsRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly
          ] = proxy(GetResourceShareInvitations, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.ram.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def getResourceShareAssociations(
              request: GetResourceShareAssociationsRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly
          ] = proxy(GetResourceShareAssociations, request)
          def listPermissions(
              request: ListPermissionsRequest
          ): IO[AwsError, zio.aws.ram.model.ListPermissionsResponse.ReadOnly] =
            proxy(ListPermissions, request)
          def promoteResourceShareCreatedFromPolicy(
              request: PromoteResourceShareCreatedFromPolicyRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.PromoteResourceShareCreatedFromPolicyResponse.ReadOnly
          ] = proxy(PromoteResourceShareCreatedFromPolicy, request)
          def acceptResourceShareInvitation(
              request: AcceptResourceShareInvitationRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly
          ] = proxy(AcceptResourceShareInvitation, request)
          def getResourcePolicies(request: GetResourcePoliciesRequest): IO[
            AwsError,
            zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly
          ] = proxy(GetResourcePolicies, request)
          def listPermissionVersions(
              request: ListPermissionVersionsRequest
          ): IO[
            AwsError,
            zio.aws.ram.model.ListPermissionVersionsResponse.ReadOnly
          ] = proxy(ListPermissionVersions, request)
        }
      }
    }
  }
}
