package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptResourceShareInvitationRequest(
    resourceShareInvitationArn: String,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest = {
    import AcceptResourceShareInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest
      .builder()
      .resourceShareInvitationArn(resourceShareInvitationArn: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.AcceptResourceShareInvitationRequest.ReadOnly =
    zio.aws.ram.model.AcceptResourceShareInvitationRequest.wrap(buildAwsValue())
}
object AcceptResourceShareInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.AcceptResourceShareInvitationRequest =
      zio.aws.ram.model.AcceptResourceShareInvitationRequest(
        resourceShareInvitationArn,
        clientToken.map(value => value)
      )
    def resourceShareInvitationArn: String
    def clientToken: Optional[String]
    def getResourceShareInvitationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareInvitationArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest
  ) extends zio.aws.ram.model.AcceptResourceShareInvitationRequest.ReadOnly {
    override val resourceShareInvitationArn: String =
      impl.resourceShareInvitationArn(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest
  ): zio.aws.ram.model.AcceptResourceShareInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
