package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptResourceShareInvitationResponse(
    resourceShareInvitation: Optional[
      zio.aws.ram.model.ResourceShareInvitation
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse = {
    import AcceptResourceShareInvitationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse
      .builder()
      .optionallyWith(
        resourceShareInvitation.map(value => value.buildAwsValue())
      )(_.resourceShareInvitation)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly =
    zio.aws.ram.model.AcceptResourceShareInvitationResponse
      .wrap(buildAwsValue())
}
object AcceptResourceShareInvitationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.AcceptResourceShareInvitationResponse =
      zio.aws.ram.model.AcceptResourceShareInvitationResponse(
        resourceShareInvitation.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def resourceShareInvitation
        : Optional[zio.aws.ram.model.ResourceShareInvitation.ReadOnly]
    def clientToken: Optional[String]
    def getResourceShareInvitation: ZIO[
      Any,
      AwsError,
      zio.aws.ram.model.ResourceShareInvitation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceShareInvitation",
      resourceShareInvitation
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse
  ) extends zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly {
    override val resourceShareInvitation
        : Optional[zio.aws.ram.model.ResourceShareInvitation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareInvitation())
        .map(value => zio.aws.ram.model.ResourceShareInvitation.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse
  ): zio.aws.ram.model.AcceptResourceShareInvitationResponse.ReadOnly =
    new Wrapper(impl)
}
