package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ram.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class AssociateResourceSharePermissionRequest(
    resourceShareArn: String,
    permissionArn: String,
    replace: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    permissionVersion: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest = {
    import AssociateResourceSharePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .permissionArn(permissionArn: java.lang.String)
      .optionallyWith(replace.map(value => value: java.lang.Boolean))(_.replace)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(permissionVersion.map(value => value: java.lang.Integer))(
        _.permissionVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.AssociateResourceSharePermissionRequest.ReadOnly =
    zio.aws.ram.model.AssociateResourceSharePermissionRequest
      .wrap(buildAwsValue())
}
object AssociateResourceSharePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.AssociateResourceSharePermissionRequest =
      zio.aws.ram.model.AssociateResourceSharePermissionRequest(
        resourceShareArn,
        permissionArn,
        replace.map(value => value),
        clientToken.map(value => value),
        permissionVersion.map(value => value)
      )
    def resourceShareArn: String
    def permissionArn: String
    def replace: Optional[Boolean]
    def clientToken: Optional[String]
    def permissionVersion: Optional[Integer]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getPermissionArn: ZIO[Any, Nothing, String] = ZIO.succeed(permissionArn)
    def getReplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("replace", replace)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPermissionVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("permissionVersion", permissionVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest
  ) extends zio.aws.ram.model.AssociateResourceSharePermissionRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val permissionArn: String = impl.permissionArn(): String
    override val replace: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.replace())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val permissionVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionVersion())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest
  ): zio.aws.ram.model.AssociateResourceSharePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
