package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateResourceSharePermissionResponse(
    returnValue: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse = {
    import AssociateResourceSharePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly =
    zio.aws.ram.model.AssociateResourceSharePermissionResponse
      .wrap(buildAwsValue())
}
object AssociateResourceSharePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.AssociateResourceSharePermissionResponse =
      zio.aws.ram.model.AssociateResourceSharePermissionResponse(
        returnValue.map(value => value),
        clientToken.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def clientToken: Optional[String]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse
  ) extends zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse
  ): zio.aws.ram.model.AssociateResourceSharePermissionResponse.ReadOnly =
    new Wrapper(impl)
}
