package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateResourceShareRequest(
    resourceShareArn: String,
    resourceArns: Optional[Iterable[String]] = Optional.Absent,
    principals: Optional[Iterable[String]] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest = {
    import AssociateResourceShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.AssociateResourceShareRequest.ReadOnly =
    zio.aws.ram.model.AssociateResourceShareRequest.wrap(buildAwsValue())
}
object AssociateResourceShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.AssociateResourceShareRequest =
      zio.aws.ram.model.AssociateResourceShareRequest(
        resourceShareArn,
        resourceArns.map(value => value),
        principals.map(value => value),
        clientToken.map(value => value)
      )
    def resourceShareArn: String
    def resourceArns: Optional[List[String]]
    def principals: Optional[List[String]]
    def clientToken: Optional[String]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getResourceArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
    def getPrincipals: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("principals", principals)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest
  ) extends zio.aws.ram.model.AssociateResourceShareRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val resourceArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val principals: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest
  ): zio.aws.ram.model.AssociateResourceShareRequest.ReadOnly = new Wrapper(
    impl
  )
}
