package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResourceShareRequest(
    name: String,
    resourceArns: Optional[Iterable[String]] = Optional.Absent,
    principals: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ram.model.Tag]] = Optional.Absent,
    allowExternalPrincipals: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    permissionArns: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.CreateResourceShareRequest = {
    import CreateResourceShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.CreateResourceShareRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        allowExternalPrincipals.map(value => value: java.lang.Boolean)
      )(_.allowExternalPrincipals)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        permissionArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.permissionArns)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.CreateResourceShareRequest.ReadOnly =
    zio.aws.ram.model.CreateResourceShareRequest.wrap(buildAwsValue())
}
object CreateResourceShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.CreateResourceShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.CreateResourceShareRequest =
      zio.aws.ram.model.CreateResourceShareRequest(
        name,
        resourceArns.map(value => value),
        principals.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        allowExternalPrincipals.map(value => value),
        clientToken.map(value => value),
        permissionArns.map(value => value)
      )
    def name: String
    def resourceArns: Optional[List[String]]
    def principals: Optional[List[String]]
    def tags: Optional[List[zio.aws.ram.model.Tag.ReadOnly]]
    def allowExternalPrincipals: Optional[Boolean]
    def clientToken: Optional[String]
    def permissionArns: Optional[List[String]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getResourceArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
    def getPrincipals: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("principals", principals)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ram.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAllowExternalPrincipals: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowExternalPrincipals", allowExternalPrincipals)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPermissionArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("permissionArns", permissionArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.CreateResourceShareRequest
  ) extends zio.aws.ram.model.CreateResourceShareRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val resourceArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val principals: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Optional[List[zio.aws.ram.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.Tag.wrap(item)
          }.toList
        )
    override val allowExternalPrincipals: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowExternalPrincipals())
        .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val permissionArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.CreateResourceShareRequest
  ): zio.aws.ram.model.CreateResourceShareRequest.ReadOnly = new Wrapper(impl)
}
