package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResourceShareResponse(
    resourceShare: Optional[zio.aws.ram.model.ResourceShare] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.CreateResourceShareResponse = {
    import CreateResourceShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.CreateResourceShareResponse
      .builder()
      .optionallyWith(resourceShare.map(value => value.buildAwsValue()))(
        _.resourceShare
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.CreateResourceShareResponse.ReadOnly =
    zio.aws.ram.model.CreateResourceShareResponse.wrap(buildAwsValue())
}
object CreateResourceShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.CreateResourceShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.CreateResourceShareResponse =
      zio.aws.ram.model.CreateResourceShareResponse(
        resourceShare.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def resourceShare: Optional[zio.aws.ram.model.ResourceShare.ReadOnly]
    def clientToken: Optional[String]
    def getResourceShare
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShare.ReadOnly] =
      AwsError.unwrapOptionField("resourceShare", resourceShare)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.CreateResourceShareResponse
  ) extends zio.aws.ram.model.CreateResourceShareResponse.ReadOnly {
    override val resourceShare
        : Optional[zio.aws.ram.model.ResourceShare.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShare())
        .map(value => zio.aws.ram.model.ResourceShare.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.CreateResourceShareResponse
  ): zio.aws.ram.model.CreateResourceShareResponse.ReadOnly = new Wrapper(impl)
}
