package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteResourceShareRequest(
    resourceShareArn: String,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest = {
    import DeleteResourceShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.DeleteResourceShareRequest.ReadOnly =
    zio.aws.ram.model.DeleteResourceShareRequest.wrap(buildAwsValue())
}
object DeleteResourceShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.DeleteResourceShareRequest =
      zio.aws.ram.model.DeleteResourceShareRequest(
        resourceShareArn,
        clientToken.map(value => value)
      )
    def resourceShareArn: String
    def clientToken: Optional[String]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest
  ) extends zio.aws.ram.model.DeleteResourceShareRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest
  ): zio.aws.ram.model.DeleteResourceShareRequest.ReadOnly = new Wrapper(impl)
}
