package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateResourceSharePermissionRequest(
    resourceShareArn: String,
    permissionArn: String,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest = {
    import DisassociateResourceSharePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest
      .builder()
      .resourceShareArn(resourceShareArn: java.lang.String)
      .permissionArn(permissionArn: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.DisassociateResourceSharePermissionRequest.ReadOnly =
    zio.aws.ram.model.DisassociateResourceSharePermissionRequest
      .wrap(buildAwsValue())
}
object DisassociateResourceSharePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ram.model.DisassociateResourceSharePermissionRequest =
      zio.aws.ram.model.DisassociateResourceSharePermissionRequest(
        resourceShareArn,
        permissionArn,
        clientToken.map(value => value)
      )
    def resourceShareArn: String
    def permissionArn: String
    def clientToken: Optional[String]
    def getResourceShareArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareArn)
    def getPermissionArn: ZIO[Any, Nothing, String] = ZIO.succeed(permissionArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest
  ) extends zio.aws.ram.model.DisassociateResourceSharePermissionRequest.ReadOnly {
    override val resourceShareArn: String = impl.resourceShareArn(): String
    override val permissionArn: String = impl.permissionArn(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest
  ): zio.aws.ram.model.DisassociateResourceSharePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
