package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateResourceSharePermissionResponse(
    returnValue: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse = {
    import DisassociateResourceSharePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly =
    zio.aws.ram.model.DisassociateResourceSharePermissionResponse
      .wrap(buildAwsValue())
}
object DisassociateResourceSharePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ram.model.DisassociateResourceSharePermissionResponse =
      zio.aws.ram.model.DisassociateResourceSharePermissionResponse(
        returnValue.map(value => value),
        clientToken.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def clientToken: Optional[String]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse
  ) extends zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse
  ): zio.aws.ram.model.DisassociateResourceSharePermissionResponse.ReadOnly =
    new Wrapper(impl)
}
