package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateResourceShareResponse(
    resourceShareAssociations: Optional[
      Iterable[zio.aws.ram.model.ResourceShareAssociation]
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse = {
    import DisassociateResourceShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse
      .builder()
      .optionallyWith(
        resourceShareAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceShareAssociations)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly =
    zio.aws.ram.model.DisassociateResourceShareResponse.wrap(buildAwsValue())
}
object DisassociateResourceShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.DisassociateResourceShareResponse =
      zio.aws.ram.model.DisassociateResourceShareResponse(
        resourceShareAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def resourceShareAssociations
        : Optional[List[zio.aws.ram.model.ResourceShareAssociation.ReadOnly]]
    def clientToken: Optional[String]
    def getResourceShareAssociations: ZIO[Any, AwsError, List[
      zio.aws.ram.model.ResourceShareAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceShareAssociations",
      resourceShareAssociations
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse
  ) extends zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly {
    override val resourceShareAssociations
        : Optional[List[zio.aws.ram.model.ResourceShareAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.ResourceShareAssociation.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse
  ): zio.aws.ram.model.DisassociateResourceShareResponse.ReadOnly = new Wrapper(
    impl
  )
}
