package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableSharingWithAwsOrganizationResponse(
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse = {
    import EnableSharingWithAwsOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly =
    zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse
      .wrap(buildAwsValue())
}
object EnableSharingWithAwsOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse =
      zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse(
        returnValue.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse
  ) extends zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse
  ): zio.aws.ram.model.EnableSharingWithAwsOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
