package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ram.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class GetPermissionRequest(
    permissionArn: String,
    permissionVersion: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetPermissionRequest = {
    import GetPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetPermissionRequest
      .builder()
      .permissionArn(permissionArn: java.lang.String)
      .optionallyWith(permissionVersion.map(value => value: java.lang.Integer))(
        _.permissionVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.GetPermissionRequest.ReadOnly =
    zio.aws.ram.model.GetPermissionRequest.wrap(buildAwsValue())
}
object GetPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetPermissionRequest =
      zio.aws.ram.model.GetPermissionRequest(
        permissionArn,
        permissionVersion.map(value => value)
      )
    def permissionArn: String
    def permissionVersion: Optional[Integer]
    def getPermissionArn: ZIO[Any, Nothing, String] = ZIO.succeed(permissionArn)
    def getPermissionVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("permissionVersion", permissionVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetPermissionRequest
  ) extends zio.aws.ram.model.GetPermissionRequest.ReadOnly {
    override val permissionArn: String = impl.permissionArn(): String
    override val permissionVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionVersion())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetPermissionRequest
  ): zio.aws.ram.model.GetPermissionRequest.ReadOnly = new Wrapper(impl)
}
