package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPermissionResponse(
    permission: Optional[zio.aws.ram.model.ResourceSharePermissionDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetPermissionResponse = {
    import GetPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetPermissionResponse
      .builder()
      .optionallyWith(permission.map(value => value.buildAwsValue()))(
        _.permission
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.GetPermissionResponse.ReadOnly =
    zio.aws.ram.model.GetPermissionResponse.wrap(buildAwsValue())
}
object GetPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetPermissionResponse = zio.aws.ram.model
      .GetPermissionResponse(permission.map(value => value.asEditable))
    def permission
        : Optional[zio.aws.ram.model.ResourceSharePermissionDetail.ReadOnly]
    def getPermission: ZIO[
      Any,
      AwsError,
      zio.aws.ram.model.ResourceSharePermissionDetail.ReadOnly
    ] = AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetPermissionResponse
  ) extends zio.aws.ram.model.GetPermissionResponse.ReadOnly {
    override val permission
        : Optional[zio.aws.ram.model.ResourceSharePermissionDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permission())
        .map(value =>
          zio.aws.ram.model.ResourceSharePermissionDetail.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetPermissionResponse
  ): zio.aws.ram.model.GetPermissionResponse.ReadOnly = new Wrapper(impl)
}
