package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetResourcePoliciesRequest(
    resourceArns: Iterable[String],
    principal: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest = {
    import GetResourcePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest
      .builder()
      .resourceArns(resourceArns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ram.model.GetResourcePoliciesRequest.ReadOnly =
    zio.aws.ram.model.GetResourcePoliciesRequest.wrap(buildAwsValue())
}
object GetResourcePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourcePoliciesRequest =
      zio.aws.ram.model.GetResourcePoliciesRequest(
        resourceArns,
        principal.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArns: List[String]
    def principal: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getResourceArns: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(resourceArns)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest
  ) extends zio.aws.ram.model.GetResourcePoliciesRequest.ReadOnly {
    override val resourceArns: List[String] = impl
      .resourceArns()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest
  ): zio.aws.ram.model.GetResourcePoliciesRequest.ReadOnly = new Wrapper(impl)
}
