package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ram.model.primitives.Policy
import scala.jdk.CollectionConverters._
final case class GetResourcePoliciesResponse(
    policies: Optional[Iterable[Policy]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse = {
    import GetResourcePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            Policy.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policies)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly =
    zio.aws.ram.model.GetResourcePoliciesResponse.wrap(buildAwsValue())
}
object GetResourcePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourcePoliciesResponse =
      zio.aws.ram.model.GetResourcePoliciesResponse(
        policies.map(value => value),
        nextToken.map(value => value)
      )
    def policies: Optional[List[Policy]]
    def nextToken: Optional[String]
    def getPolicies: ZIO[Any, AwsError, List[Policy]] =
      AwsError.unwrapOptionField("policies", policies)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse
  ) extends zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly {
    override val policies: Optional[List[Policy]] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ram.model.primitives.Policy(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse
  ): zio.aws.ram.model.GetResourcePoliciesResponse.ReadOnly = new Wrapper(impl)
}
