package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetResourceShareAssociationsRequest(
    associationType: zio.aws.ram.model.ResourceShareAssociationType,
    resourceShareArns: Optional[Iterable[String]] = Optional.Absent,
    resourceArn: Optional[String] = Optional.Absent,
    principal: Optional[String] = Optional.Absent,
    associationStatus: Optional[
      zio.aws.ram.model.ResourceShareAssociationStatus
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest = {
    import GetResourceShareAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest
      .builder()
      .associationType(associationType.unwrap)
      .optionallyWith(
        resourceShareArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShareArns)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .optionallyWith(associationStatus.map(value => value.unwrap))(
        _.associationStatus
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.GetResourceShareAssociationsRequest.ReadOnly =
    zio.aws.ram.model.GetResourceShareAssociationsRequest.wrap(buildAwsValue())
}
object GetResourceShareAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourceShareAssociationsRequest =
      zio.aws.ram.model.GetResourceShareAssociationsRequest(
        associationType,
        resourceShareArns.map(value => value),
        resourceArn.map(value => value),
        principal.map(value => value),
        associationStatus.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def associationType: zio.aws.ram.model.ResourceShareAssociationType
    def resourceShareArns: Optional[List[String]]
    def resourceArn: Optional[String]
    def principal: Optional[String]
    def associationStatus
        : Optional[zio.aws.ram.model.ResourceShareAssociationStatus]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getAssociationType
        : ZIO[Any, Nothing, zio.aws.ram.model.ResourceShareAssociationType] =
      ZIO.succeed(associationType)
    def getResourceShareArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceShareArns", resourceShareArns)
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
    def getAssociationStatus
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareAssociationStatus] =
      AwsError.unwrapOptionField("associationStatus", associationStatus)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest
  ) extends zio.aws.ram.model.GetResourceShareAssociationsRequest.ReadOnly {
    override val associationType
        : zio.aws.ram.model.ResourceShareAssociationType =
      zio.aws.ram.model.ResourceShareAssociationType
        .wrap(impl.associationType())
    override val resourceShareArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
    override val associationStatus
        : Optional[zio.aws.ram.model.ResourceShareAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationStatus())
        .map(value =>
          zio.aws.ram.model.ResourceShareAssociationStatus.wrap(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest
  ): zio.aws.ram.model.GetResourceShareAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
