package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceShareAssociationsResponse(
    resourceShareAssociations: Optional[
      Iterable[zio.aws.ram.model.ResourceShareAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse = {
    import GetResourceShareAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse
      .builder()
      .optionallyWith(
        resourceShareAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceShareAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly =
    zio.aws.ram.model.GetResourceShareAssociationsResponse.wrap(buildAwsValue())
}
object GetResourceShareAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourceShareAssociationsResponse =
      zio.aws.ram.model.GetResourceShareAssociationsResponse(
        resourceShareAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceShareAssociations
        : Optional[List[zio.aws.ram.model.ResourceShareAssociation.ReadOnly]]
    def nextToken: Optional[String]
    def getResourceShareAssociations: ZIO[Any, AwsError, List[
      zio.aws.ram.model.ResourceShareAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceShareAssociations",
      resourceShareAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse
  ) extends zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly {
    override val resourceShareAssociations
        : Optional[List[zio.aws.ram.model.ResourceShareAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.ResourceShareAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse
  ): zio.aws.ram.model.GetResourceShareAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
