package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetResourceShareInvitationsRequest(
    resourceShareInvitationArns: Optional[Iterable[String]] = Optional.Absent,
    resourceShareArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest = {
    import GetResourceShareInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest
      .builder()
      .optionallyWith(
        resourceShareInvitationArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShareInvitationArns)
      .optionallyWith(
        resourceShareArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShareArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.GetResourceShareInvitationsRequest.ReadOnly =
    zio.aws.ram.model.GetResourceShareInvitationsRequest.wrap(buildAwsValue())
}
object GetResourceShareInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourceShareInvitationsRequest =
      zio.aws.ram.model.GetResourceShareInvitationsRequest(
        resourceShareInvitationArns.map(value => value),
        resourceShareArns.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceShareInvitationArns: Optional[List[String]]
    def resourceShareArns: Optional[List[String]]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getResourceShareInvitationArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "resourceShareInvitationArns",
        resourceShareInvitationArns
      )
    def getResourceShareArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceShareArns", resourceShareArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest
  ) extends zio.aws.ram.model.GetResourceShareInvitationsRequest.ReadOnly {
    override val resourceShareInvitationArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareInvitationArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val resourceShareArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest
  ): zio.aws.ram.model.GetResourceShareInvitationsRequest.ReadOnly =
    new Wrapper(impl)
}
