package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceShareInvitationsResponse(
    resourceShareInvitations: Optional[
      Iterable[zio.aws.ram.model.ResourceShareInvitation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse = {
    import GetResourceShareInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse
      .builder()
      .optionallyWith(
        resourceShareInvitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceShareInvitations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly =
    zio.aws.ram.model.GetResourceShareInvitationsResponse.wrap(buildAwsValue())
}
object GetResourceShareInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourceShareInvitationsResponse =
      zio.aws.ram.model.GetResourceShareInvitationsResponse(
        resourceShareInvitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceShareInvitations
        : Optional[List[zio.aws.ram.model.ResourceShareInvitation.ReadOnly]]
    def nextToken: Optional[String]
    def getResourceShareInvitations: ZIO[Any, AwsError, List[
      zio.aws.ram.model.ResourceShareInvitation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceShareInvitations",
      resourceShareInvitations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse
  ) extends zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly {
    override val resourceShareInvitations
        : Optional[List[zio.aws.ram.model.ResourceShareInvitation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareInvitations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.ResourceShareInvitation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse
  ): zio.aws.ram.model.GetResourceShareInvitationsResponse.ReadOnly =
    new Wrapper(impl)
}
