package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetResourceSharesRequest(
    resourceShareArns: Optional[Iterable[String]] = Optional.Absent,
    resourceShareStatus: Optional[zio.aws.ram.model.ResourceShareStatus] =
      Optional.Absent,
    resourceOwner: zio.aws.ram.model.ResourceOwner,
    name: Optional[String] = Optional.Absent,
    tagFilters: Optional[Iterable[zio.aws.ram.model.TagFilter]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    permissionArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourceSharesRequest = {
    import GetResourceSharesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourceSharesRequest
      .builder()
      .optionallyWith(
        resourceShareArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceShareArns)
      .optionallyWith(resourceShareStatus.map(value => value.unwrap))(
        _.resourceShareStatus
      )
      .resourceOwner(resourceOwner.unwrap)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        tagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagFilters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(permissionArn.map(value => value: java.lang.String))(
        _.permissionArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.GetResourceSharesRequest.ReadOnly =
    zio.aws.ram.model.GetResourceSharesRequest.wrap(buildAwsValue())
}
object GetResourceSharesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourceSharesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourceSharesRequest =
      zio.aws.ram.model.GetResourceSharesRequest(
        resourceShareArns.map(value => value),
        resourceShareStatus.map(value => value),
        resourceOwner,
        name.map(value => value),
        tagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value),
        permissionArn.map(value => value)
      )
    def resourceShareArns: Optional[List[String]]
    def resourceShareStatus: Optional[zio.aws.ram.model.ResourceShareStatus]
    def resourceOwner: zio.aws.ram.model.ResourceOwner
    def name: Optional[String]
    def tagFilters: Optional[List[zio.aws.ram.model.TagFilter.ReadOnly]]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def permissionArn: Optional[String]
    def getResourceShareArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceShareArns", resourceShareArns)
    def getResourceShareStatus
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceShareStatus] =
      AwsError.unwrapOptionField("resourceShareStatus", resourceShareStatus)
    def getResourceOwner: ZIO[Any, Nothing, zio.aws.ram.model.ResourceOwner] =
      ZIO.succeed(resourceOwner)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTagFilters
        : ZIO[Any, AwsError, List[zio.aws.ram.model.TagFilter.ReadOnly]] =
      AwsError.unwrapOptionField("tagFilters", tagFilters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getPermissionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("permissionArn", permissionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourceSharesRequest
  ) extends zio.aws.ram.model.GetResourceSharesRequest.ReadOnly {
    override val resourceShareArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val resourceShareStatus
        : Optional[zio.aws.ram.model.ResourceShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareStatus())
        .map(value => zio.aws.ram.model.ResourceShareStatus.wrap(value))
    override val resourceOwner: zio.aws.ram.model.ResourceOwner =
      zio.aws.ram.model.ResourceOwner.wrap(impl.resourceOwner())
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val tagFilters
        : Optional[List[zio.aws.ram.model.TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.TagFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
    override val permissionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourceSharesRequest
  ): zio.aws.ram.model.GetResourceSharesRequest.ReadOnly = new Wrapper(impl)
}
