package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceSharesResponse(
    resourceShares: Optional[Iterable[zio.aws.ram.model.ResourceShare]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.GetResourceSharesResponse = {
    import GetResourceSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.GetResourceSharesResponse
      .builder()
      .optionallyWith(
        resourceShares.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceShares)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ram.model.GetResourceSharesResponse.ReadOnly =
    zio.aws.ram.model.GetResourceSharesResponse.wrap(buildAwsValue())
}
object GetResourceSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.GetResourceSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.GetResourceSharesResponse =
      zio.aws.ram.model.GetResourceSharesResponse(
        resourceShares.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceShares: Optional[List[zio.aws.ram.model.ResourceShare.ReadOnly]]
    def nextToken: Optional[String]
    def getResourceShares
        : ZIO[Any, AwsError, List[zio.aws.ram.model.ResourceShare.ReadOnly]] =
      AwsError.unwrapOptionField("resourceShares", resourceShares)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.GetResourceSharesResponse
  ) extends zio.aws.ram.model.GetResourceSharesResponse.ReadOnly {
    override val resourceShares
        : Optional[List[zio.aws.ram.model.ResourceShare.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShares())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.ResourceShare.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.GetResourceSharesResponse
  ): zio.aws.ram.model.GetResourceSharesResponse.ReadOnly = new Wrapper(impl)
}
