package zio.aws.ram.model
import zio.aws.ram.model.primitives.MaxResults
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPendingInvitationResourcesRequest(
    resourceShareInvitationArn: String,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resourceRegionScope: Optional[zio.aws.ram.model.ResourceRegionScopeFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest = {
    import ListPendingInvitationResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest
      .builder()
      .resourceShareInvitationArn(resourceShareInvitationArn: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(resourceRegionScope.map(value => value.unwrap))(
        _.resourceRegionScope
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.ListPendingInvitationResourcesRequest.ReadOnly =
    zio.aws.ram.model.ListPendingInvitationResourcesRequest
      .wrap(buildAwsValue())
}
object ListPendingInvitationResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListPendingInvitationResourcesRequest =
      zio.aws.ram.model.ListPendingInvitationResourcesRequest(
        resourceShareInvitationArn,
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceRegionScope.map(value => value)
      )
    def resourceShareInvitationArn: String
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def resourceRegionScope
        : Optional[zio.aws.ram.model.ResourceRegionScopeFilter]
    def getResourceShareInvitationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceShareInvitationArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceRegionScope
        : ZIO[Any, AwsError, zio.aws.ram.model.ResourceRegionScopeFilter] =
      AwsError.unwrapOptionField("resourceRegionScope", resourceRegionScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest
  ) extends zio.aws.ram.model.ListPendingInvitationResourcesRequest.ReadOnly {
    override val resourceShareInvitationArn: String =
      impl.resourceShareInvitationArn(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ram.model.primitives.MaxResults(value))
    override val resourceRegionScope
        : Optional[zio.aws.ram.model.ResourceRegionScopeFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRegionScope())
        .map(value => zio.aws.ram.model.ResourceRegionScopeFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest
  ): zio.aws.ram.model.ListPendingInvitationResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
