package zio.aws.ram.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPendingInvitationResourcesResponse(
    resources: Optional[Iterable[zio.aws.ram.model.Resource]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse = {
    import ListPendingInvitationResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly =
    zio.aws.ram.model.ListPendingInvitationResourcesResponse
      .wrap(buildAwsValue())
}
object ListPendingInvitationResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ram.model.ListPendingInvitationResourcesResponse =
      zio.aws.ram.model.ListPendingInvitationResourcesResponse(
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resources: Optional[List[zio.aws.ram.model.Resource.ReadOnly]]
    def nextToken: Optional[String]
    def getResources
        : ZIO[Any, AwsError, List[zio.aws.ram.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("resources", resources)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse
  ) extends zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly {
    override val resources
        : Optional[List[zio.aws.ram.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ram.model.Resource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse
  ): zio.aws.ram.model.ListPendingInvitationResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
